<?php
/*
  $Id: customers_improved.php, v1.5.3 2008/11/29 13:54:44 stevedallas Exp $

  v1.5.3 29 Nov 2008 GCH $orderby and $sort are in the $HTTP_GET_VARS array, not $HTTP_POST_VARS.
                           Fixed code; this problem only appears with register_globals=off

  v1.5.2 23 Nov 2008 GCH Rebuilt tables for correct structure
                         Many changes for HTML DTD conformance
                         Date of birth column in list is now displayed only if store configuration uses it
                         Regrouped contents of edit page for consistency
                           Company name (if used) is now part of the Address group
                           Address selector moved inside Address box
                         Icons for support of other contributions are only displayed if those modules are installed
                           (Admin Create Account #5388, Manual Order Maker #4829, and Admin Change Customer Passwords #4469)
                         Added 'Sort by newsletter subscription status' from v1.4.3
                         Functions tep_address_label() and tep_get_address_format_id do not exist in admin/includes/functions/general.php

Customers Improved v1.5.3

Copyright (c) 2005 Wesley Haines
<kremit AT wrpn.net>, http://wrpn.net/


  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  require('includes/application_top.php');

  $action = (isset($HTTP_GET_VARS['action']) ? $HTTP_GET_VARS['action'] : '');

if(isset($HTTP_GET_VARS['orderby'])) $orderby = tep_db_prepare_input($HTTP_GET_VARS['orderby']);
if(isset($HTTP_GET_VARS['sort'])) $sort = tep_db_prepare_input($HTTP_GET_VARS['sort']);
if(!$orderby) $orderby = 'lastname';
if(!$sort) $sort = 'ASC';

// Check whether other modules are installed
$has_create_account = (FILENAME_CREATE_ACCOUNT !== 'FILENAME_CREATE_ACCOUNT');
$has_create_order = (FILENAME_CREATE_ORDER !== 'FILENAME_CREATE_ORDER');
$has_change_password = (FILENAME_CHANGE_PASSWORD !== 'FILENAME_CHANGE_PASSWORD');

  $error = false;
  $processed = false;

// The following two functions copied from catalog/includes/functions/general.php, because they don't exist in 
// the admin version of general.php 
  if (!function_exists("tep_address_label")) {
////
// Return a formatted address
// TABLES: customers, address_book
    function tep_address_label($customers_id, $address_id = 1, $html = false, $boln = '', $eoln = "\n") {
      if (is_array($address_id) && !empty($address_id)) {
        return tep_address_format($address_id['address_format_id'], $address_id, $html, $boln, $eoln);
      }
      $address_query = tep_db_query("select entry_firstname as firstname, entry_lastname as lastname, entry_company as company, entry_street_address as street_address, entry_suburb as suburb, entry_city as city, entry_postcode as postcode, entry_state as state, entry_zone_id as zone_id, entry_country_id as country_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customers_id . "' and address_book_id = '" . (int)$address_id . "'");
      $address = tep_db_fetch_array($address_query);

      $format_id = tep_get_address_format_id($address['country_id']);

      return tep_address_format($format_id, $address, $html, $boln, $eoln);
    }
  }

  if (!function_exists("tep_get_address_format_id")) {
////
// Returns the address_format_id for the given country
// TABLES: countries;
    function tep_get_address_format_id($country_id) {
      $address_format_query = tep_db_query("select address_format_id as format_id from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");
      if (tep_db_num_rows($address_format_query)) {
        $address_format = tep_db_fetch_array($address_format_query);
        return $address_format['format_id'];
      } else {
        return '1';
      }
    }
  }


  if (tep_not_null($action)) {
    switch ($action) {
// Admin edit any customer address begin
      case 'confirmaddressdelete':
        if (!isset($HTTP_GET_VARS['cID']) || !isset($HTTP_GET_VARS['add_id'])) // if either id not set
          tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('action', 'add_id'))));
        $check_default_query = tep_db_query("select customers_default_address_id as defid from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$HTTP_GET_VARS['cID'] . "'");
        if ($default = tep_db_fetch_array($check_default_query)) {
          if ($HTTP_GET_VARS['add_id'] == $default['defid']) {// may not delete default address
            tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('action')) . 'action=deladdress'));
          } else {
            tep_db_query("delete from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$HTTP_GET_VARS['cID'] . "' and address_book_id = '" . (int)$HTTP_GET_VARS['add_id'] . "'");
            tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('action', 'add_id')) . 'action=edit'));
          }
        } else { // no match on cID
          tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action', 'add_id'))));
        }
        break;
		
		
		
		
// Admin edit any customer address end
      case 'update':
        $customers_id = tep_db_prepare_input($HTTP_GET_VARS['cID']);
        $customers_firstname = tep_db_prepare_input($HTTP_POST_VARS['customers_firstname']);
        $customers_lastname = tep_db_prepare_input($HTTP_POST_VARS['customers_lastname']);
// Admin edit any customer address begin
        $entry_firstname = tep_db_prepare_input($HTTP_POST_VARS['entry_firstname']);
        $entry_lastname = tep_db_prepare_input($HTTP_POST_VARS['entry_lastname']);
// Admin edit any customer address end

        $customers_email_address = tep_db_prepare_input($HTTP_POST_VARS['customers_email_address']);
        $customers_telephone = tep_db_prepare_input($HTTP_POST_VARS['customers_telephone']);
        $customers_fax = tep_db_prepare_input($HTTP_POST_VARS['customers_fax']);
        $customers_newsletter = tep_db_prepare_input($HTTP_POST_VARS['customers_newsletter']);

        $customers_gender = tep_db_prepare_input($HTTP_POST_VARS['customers_gender']);
        $customers_dob = tep_db_prepare_input($HTTP_POST_VARS['customers_dob']);
// Admin edit any customer address begin
//        $default_address_id = tep_db_prepare_input($HTTP_POST_VARS['default_address_id']);
        $default_address_id = (isset($HTTP_GET_VARS['add_id']) ? tep_db_prepare_input($HTTP_GET_VARS['add_id']) : tep_db_prepare_input($HTTP_POST_VARS['default_address_id']));
// Admin edit any customer address end
        $entry_street_address = tep_db_prepare_input($HTTP_POST_VARS['entry_street_address']);
        $entry_suburb = tep_db_prepare_input($HTTP_POST_VARS['entry_suburb']);
        $entry_postcode = tep_db_prepare_input($HTTP_POST_VARS['entry_postcode']);
        $entry_city = tep_db_prepare_input($HTTP_POST_VARS['entry_city']);
        $entry_country_id = tep_db_prepare_input($HTTP_POST_VARS['entry_country_id']);

        $entry_company = tep_db_prepare_input($HTTP_POST_VARS['entry_company']);
		    // ajout pour tva intracom
		$entry_tva_intracom = tep_db_prepare_input($HTTP_POST_VARS['entry_tva_intracom']);
		// fin ajout
        $entry_state = tep_db_prepare_input($HTTP_POST_VARS['entry_state']);
        if (isset($HTTP_POST_VARS['entry_zone_id'])) $entry_zone_id = tep_db_prepare_input($HTTP_POST_VARS['entry_zone_id']);

// Admin edit any customer address begin
        if (strlen($customers_firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
          $error = true;
          $customers_firstname_error = true;
        } else {
          $customers_firstname_error = false;
        }

        if (strlen($customers_lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
          $error = true;
          $customers_lastname_error = true;
        } else {
          $customers_lastname_error = false;
        }

        if (strlen($entry_firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
          $error = true;
          $entry_firstname_error = true;
        } else {
          $entry_firstname_error = false;
        }

        if (strlen($entry_lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
          $error = true;
          $entry_lastname_error = true;
        } else {
          $entry_lastname_error = false;
        }
// Admin edit any customer address end

        if (ACCOUNT_DOB == 'true') {
          if (checkdate(substr(tep_date_raw($customers_dob), 4, 2), substr(tep_date_raw($customers_dob), 6, 2), substr(tep_date_raw($customers_dob), 0, 4))) {
          $customers_date_of_birth_error = false; // Admin edit any customer address
          } else {
            $error = true;
          $customers_date_of_birth_error = true; // Admin edit any customer address
          }
        }

        if (strlen($customers_email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
          $error = true;
          $customers_email_address_error = true; // Admin edit any customer address
        } else {
          $customers_email_address_error = false; // Admin edit any customer address
        }
// Ajout pour TVA_INTRACOM_v3.3
 if (ACCOUNT_COMPANY == 'true') {
   if ( (strlen($entry_company) != 0) && (strlen($entry_company) < ENTRY_COMPANY_MIN_LENGTH) ) {
     $error = true;
     $entry_company_error = true;
   } else {
     $entry_company_error = false;
   }
   if ( ENTRY_TVA_INTRACOM_CHECK == 'true') {					
     if (strlen($entry_tva_intracom) != 0) {
       // Begin update for TVA_INTRACOM_v3.9							
       if ($entry_country_id != false) {
		$country_code_query = tep_db_query("select countries_iso_code_2 from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$entry_country_id . "'");
		$country_code_value = tep_db_fetch_array($country_code_query);
		$countries_array = array('countries_iso_code_2' => $country_code_value['countries_iso_code_2']);
		if ( (array_search($countries_array['countries_iso_code_2'], array_keys(tep_get_tva_intracom_array())) === false) || ($countries_array['countries_iso_code_2'] != substr(strtoupper(trim($entry_tva_intracom)),0,2)) ) {
			$error = true;									
			$entry_tva_intracom_error = 'true';
		} else {
			$entry_tva_intracom_error = 'false';
		}
       }
       // End update for TVA_INTRACOM_v3.9
       $result_tva = tep_verif_tva(strtoupper(rtrim($tva_intracom)));
       if ($result_tva == 'false') {
         $error = true;
	 $entry_tva_intracom_error = 'true';
       } elseif ($result_tva == 'no_verif') {
         $error = true;
	 $entry_tva_intracom_error = 'no_verif';
       } else {
	 //$entry_tva_intracom_error = 'false';
         // Begin update for TVA_INTRACOM_v3.9
         if ($entry_tva_intracom_error != 'true') {
           $entry_tva_intracom_error = 'false';
         }
         // End update for TVA_INTRACOM_v3.9
       }
     }
   } else {
     if ( (strlen($entry_tva_intracom) != 0) && (strlen($entry_tva_intracom) < ENTRY_TVA_INTRACOM_MIN_LENGTH) ) {
       $error = true;
       $entry_tva_intracom_error = 'true';
     } else {
       $entry_tva_intracom_error = 'false';
     }
   }
 }
	// Fin ajout pour TVA_INTRACOM_v3.3
	
        if (!tep_validate_email($customers_email_address)) {
          $error = true;
          $customers_email_address_check_error = true; // Admin edit any customer address
        } else {
          $customers_email_address_check_error = false; // Admin edit any customer address
        }

        if (strlen($entry_street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
          $error = true;
          $entry_street_address_error = true;
        } else {
          $entry_street_address_error = false;
        }

        if (strlen($entry_postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
          $error = true;
          $entry_post_code_error = true;
        } else {
          $entry_post_code_error = false;
        }

        if (strlen($entry_city) < ENTRY_CITY_MIN_LENGTH) {
          $error = true;
          $entry_city_error = true;
        } else {
          $entry_city_error = false;
        }

        if ($entry_country_id == false) {
          $error = true;
          $entry_country_error = true;
        } else {
          $entry_country_error = false;
        }

        if (ACCOUNT_STATE == 'true') {
          if ($entry_country_error == true) {
            $entry_state_error = true;
          } else {
            $zone_id = 0;
            $entry_state_error = false;
            $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "'");
            $check_value = tep_db_fetch_array($check_query);
            $entry_state_has_zones = ($check_value['total'] > 0);
            if ($entry_state_has_zones == true) {
              $zone_query = tep_db_query("select zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "' and zone_name = '" . tep_db_input($entry_state) . "'");
              if (tep_db_num_rows($zone_query) == 1) {
                $zone_values = tep_db_fetch_array($zone_query);
                $entry_zone_id = $zone_values['zone_id'];
              } else {
                $error = true;
                $entry_state_error = true;
              }
            } else {
              if ($entry_state == false) {
                $error = true;
                $entry_state_error = true;
              }
            }
         }
      }

      if (strlen($customers_telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
        $error = true;
        $entry_telephone_error = true;
      } else {
        $entry_telephone_error = false;
      }

      $check_email = tep_db_query("select customers_email_address from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($customers_email_address) . "' and customers_id != '" . (int)$customers_id . "'");
      if (tep_db_num_rows($check_email)) {
        $error = true;
        $customers_email_address_exists = true; // Admin edit any customer address
      } else {
        $customers_email_address_exists = false; // Admin edit any customer address
      }

      if ($error == false) {

        $sql_data_array = array('customers_firstname' => $customers_firstname,
                                'customers_lastname' => $customers_lastname,
                                'customers_email_address' => $customers_email_address,
                                'customers_telephone' => $customers_telephone,
                                'customers_fax' => $customers_fax,
                                'customers_newsletter' => $customers_newsletter);

        if (ACCOUNT_GENDER == 'true') $sql_data_array['customers_gender'] = $customers_gender;
        if (ACCOUNT_DOB == 'true') $sql_data_array['customers_dob'] = tep_date_raw($customers_dob);

        tep_db_perform(TABLE_CUSTOMERS, $sql_data_array, 'update', "customers_id = '" . (int)$customers_id . "'");

        tep_db_query("update " . TABLE_CUSTOMERS_INFO . " set customers_info_date_account_last_modified = now() where customers_info_id = '" . (int)$customers_id . "'");

        if ($entry_zone_id > 0) $entry_state = '';

// Admin edit any customer address begin
//        $sql_data_array = array('entry_firstname' => $customers_firstname,
//                                'entry_lastname' => $customers_lastname,
        $sql_data_array = array('entry_firstname' => $entry_firstname,
                                'entry_lastname' => $entry_lastname,
// Admin edit any customer address end
                                'entry_street_address' => $entry_street_address,
                                'entry_postcode' => $entry_postcode,
                                'entry_city' => $entry_city,
                                'entry_country_id' => $entry_country_id);

        if (ACCOUNT_COMPANY == 'true') $sql_data_array['entry_company'] = $entry_company;
		// Ajout pour TVA_INTRACOM_v3.3
		if (ACCOUNT_COMPANY == 'true') $sql_data_array['entry_tva_intracom'] = $entry_tva_intracom;
	// Fin ajout pour TVA_INTRACOM_v3.3

        if (ACCOUNT_SUBURB == 'true') $sql_data_array['entry_suburb'] = $entry_suburb;

        if (ACCOUNT_STATE == 'true') {
          if ($entry_zone_id > 0) {
            $sql_data_array['entry_zone_id'] = $entry_zone_id;
            $sql_data_array['entry_state'] = '';
          } else {
            $sql_data_array['entry_zone_id'] = '0';
            $sql_data_array['entry_state'] = $entry_state;
          }
        }

        tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array, 'update', "customers_id = '" . (int)$customers_id . "' and address_book_id = '" . (int)$default_address_id . "'");

// Admin edit any customer address begin
//        tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action')) . 'cID=' . $customers_id));
// enable next line to redirect customers list after editing data, disable the other
//        tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action', 'add_id')) . 'cID=' . $customers_id));
// enable next line to stay in edition view after editing data, disable the other
        tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('action')) . 'action=edit'));
// Admin edit any customer address end

        } else if ($error == true) {
          $cInfo = new objectInfo($HTTP_POST_VARS);
          $processed = true;
        }

        break;
      case 'deleteconfirm':
        $customers_id = tep_db_prepare_input($HTTP_GET_VARS['cID']);

        if (isset($HTTP_POST_VARS['delete_reviews']) && ($HTTP_POST_VARS['delete_reviews'] == 'on')) {
          $reviews_query = tep_db_query("select reviews_id from " . TABLE_REVIEWS . " where customers_id = '" . (int)$customers_id . "'");
          while ($reviews = tep_db_fetch_array($reviews_query)) {
            tep_db_query("delete from " . TABLE_REVIEWS_DESCRIPTION . " where reviews_id = '" . (int)$reviews['reviews_id'] . "'");
          }

          tep_db_query("delete from " . TABLE_REVIEWS . " where customers_id = '" . (int)$customers_id . "'");
        } else {
          tep_db_query("update " . TABLE_REVIEWS . " set customers_id = null where customers_id = '" . (int)$customers_id . "'");
        }

        tep_db_query("delete from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customers_id . "'");
        tep_db_query("delete from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customers_id . "'");
        tep_db_query("delete from " . TABLE_CUSTOMERS_INFO . " where customers_info_id = '" . (int)$customers_id . "'");
        tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . (int)$customers_id . "'");
        tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET_ATTRIBUTES . " where customers_id = '" . (int)$customers_id . "'");
        tep_db_query("delete from " . TABLE_WHOS_ONLINE . " where customer_id = '" . (int)$customers_id . "'");

        tep_redirect(tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action'))));
        break;
      default:
// Admin edit any customer address begin
//        $customers_query = tep_db_query("select c.customers_id, c.customers_gender, c.customers_firstname, c.customers_lastname, c.customers_dob, c.customers_email_address, a.entry_company, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id, c.customers_telephone, c.customers_fax, c.customers_newsletter, c.customers_default_address_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on c.customers_default_address_id = a.address_book_id where a.customers_id = c.customers_id and c.customers_id = '" . (int)$HTTP_GET_VARS['cID'] . "'");
        $customers_query = tep_db_query("select c.customers_id, c.customers_gender, c.customers_firstname, c.customers_lastname, c.customers_dob, c.customers_email_address, a.entry_firstname, a.entry_lastname, a.entry_company, a.entry_tva_intracom, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id, c.customers_telephone, c.customers_fax, c.customers_newsletter, c.customers_default_address_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on a.address_book_id = " . (isset($HTTP_GET_VARS['add_id']) ? (int)$HTTP_GET_VARS['add_id'] : 'c.customers_default_address_id') . " where a.customers_id = c.customers_id and c.customers_id = '" . (int)$HTTP_GET_VARS['cID'] . "'");
// Admin edit any customer address end
        $customers = tep_db_fetch_array($customers_query);
        $cInfo = new objectInfo($customers);
// Admin edit any customer address begin
        $customer_address_query = tep_db_query("select address_book_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$HTTP_GET_VARS['cID'] . "'");
        $aid_list = array();
        while ($a = tep_db_fetch_array($customer_address_query))
          { $aid_list[] = $a['address_book_id'];}
// Admin edit any customer address end
    }
  }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html <?php echo HTML_PARAMS; ?>>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
    <title><?php echo TITLE; ?></title>
    <link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
    <script language="javascript" type="text/javascript" src="includes/general.js"></script>
<?php
  if ($action == 'edit' || $action == 'update') {
?>
    <script language="javascript" type="text/javascript"><!--

function check_form() {
  var error = 0;
  var error_message = "<?php echo JS_ERROR; ?>";

  var customers_firstname = document.customers.customers_firstname.value;
  var customers_lastname = document.customers.customers_lastname.value;
/* Admin edit any customer address */
  var entry_firstname = document.customers.entry_firstname.value;
  var entry_lastname = document.customers.entry_lastname.value;
/* Admin edit any customer address */
<?php if (ACCOUNT_COMPANY == 'true') echo 'var entry_company = document.customers.entry_company.value;' . "\n"; ?>
<!-- Ajout pour TVA_INTRACOM_v3.3	//-->
		<?php if (ACCOUNT_COMPANY == 'true') echo 'var entry_tva_intracom = document.customers.entry_tva_intracom.value;' . "\n"; ?>
	<!-- Fin ajout pour TVA_INTRACOM_v3.3	//-->

<?php if (ACCOUNT_DOB == 'true') echo 'var customers_dob = document.customers.customers_dob.value;' . "\n"; ?>
  var customers_email_address = document.customers.customers_email_address.value;
  var entry_street_address = document.customers.entry_street_address.value;
  var entry_postcode = document.customers.entry_postcode.value;
  var entry_city = document.customers.entry_city.value;
  var customers_telephone = document.customers.customers_telephone.value;

<?php if (ACCOUNT_GENDER == 'true') { ?>
  if (document.customers.customers_gender[0].checked || document.customers.customers_gender[1].checked) {
  } else {
    error_message = error_message + "<?php echo JS_GENDER; ?>";
    error = 1;
  }
<?php } ?>

  if (customers_firstname == "" || customers_firstname.length < <?php echo ENTRY_FIRST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_FIRST_NAME; ?>";
    error = 1;
  }

  if (customers_lastname == "" || customers_lastname.length < <?php echo ENTRY_LAST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_LAST_NAME; ?>";
    error = 1;
  }
/* Admin edit any customer address */
  if (entry_firstname.length < <?php echo ENTRY_FIRST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_FIRST_NAME; ?>";
    error = 1;
  }

  if (entry_lastname.length < <?php echo ENTRY_LAST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_LAST_NAME; ?>";
    error = 1;
  }
/* Admin edit any customer address */

<?php if (ACCOUNT_DOB == 'true') { ?>
  if (customers_dob == "" || customers_dob.length < <?php echo ENTRY_DOB_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_DOB; ?>";
    error = 1;
  }
<?php } ?>

  if (customers_email_address == "" || customers_email_address.length < <?php echo ENTRY_EMAIL_ADDRESS_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_EMAIL_ADDRESS; ?>";
    error = 1;
  }
	<!-- Ajout pour TVA_INTRACOM_v3.3	//-->
	<?php if (ACCOUNT_COMPANY == 'true') { ?>
 	 if (entry_company != "" && entry_company.length < <?php echo ENTRY_COMPANY_MIN_LENGTH; ?>) {
 	   error_message = error_message + "<?php echo JS_COMPANY; ?>";
	    error = 1;
	  }
		if (entry_tva_intracom != "" && entry_tva_intracom.length < <?php echo ENTRY_TVA_INTRACOM_MIN_LENGTH; ?>) {
	    error_message = error_message + "<?php echo JS_TVA_INTRACOM; ?>";
	    error = 1;
	  }
	<?php } ?>
	<!-- Fin ajout pour TVA_INTRACOM_v3.3	//-->
  if (entry_street_address == "" || entry_street_address.length < <?php echo ENTRY_STREET_ADDRESS_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_ADDRESS; ?>";
    error = 1;
  }

  if (entry_postcode == "" || entry_postcode.length < <?php echo ENTRY_POSTCODE_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_POST_CODE; ?>";
    error = 1;
  }

  if (entry_city == "" || entry_city.length < <?php echo ENTRY_CITY_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_CITY; ?>";
    error = 1;
  }

<?php
  if (ACCOUNT_STATE == 'true') {
?>
  if (document.customers.elements['entry_state'].type != "hidden") {
    if (document.customers.entry_state.value == '' || document.customers.entry_state.value.length < <?php echo ENTRY_STATE_MIN_LENGTH; ?> ) {
       error_message = error_message + "<?php echo JS_STATE; ?>";
       error = 1;
    }
  }
<?php
  }
?>

  if (document.customers.elements['entry_country_id'].type != "hidden") {
    if (document.customers.entry_country_id.value == 0) {
      error_message = error_message + "<?php echo JS_COUNTRY; ?>";
      error = 1;
    }
  }

  if (customers_telephone == "" || customers_telephone.length < <?php echo ENTRY_TELEPHONE_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_TELEPHONE; ?>";
    error = 1;
  }

  if (error == 1) {
    alert(error_message);
    return false;
  } else {
    return true;
  }
}
//-->
    </script>
<?php
  }
?>
  </head>
  <body onload="SetFocus();">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
    <table border="0" width="100%" cellspacing="2" cellpadding="2">
      <tr>
        <td width="<?php echo BOX_WIDTH; ?>" valign="top" id="left">
          <table border="0" width="<?php echo BOX_WIDTH; ?>" cellspacing="1" cellpadding="1" class="columnLeft">
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
          </table>
        </td>
<!-- body_text //-->
        <td width="100%" valign="top" id="main">
          <table border="0" width="100%" cellspacing="0" cellpadding="2">
<?php
  if ($action == 'edit' || $action == 'update' || $action == 'deladdress') {
//
// Edit customer information
//
    $newsletter_array = array(array('id' => '1', 'text' => SET_NEWSLETTER_YES),
                              array('id' => '0', 'text' => SET_NEWSLETTER_NO));
?>
            <tr>
              <td>
                <table border="0" width="100%" cellspacing="0" cellpadding="0">
                  <tr>
                    <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
                    <td class="pageHeading" align="right"><?php echo tep_draw_separator('pixel_trans.gif', HEADING_IMAGE_WIDTH, HEADING_IMAGE_HEIGHT); ?></td>
                  </tr>
                </table>
              </td>
            </tr>
<?php
if($action == 'deladdress') {
?>
            <tr>
              <td width="100%"><div class="messageStackWarning" style="margin: 1em 0; padding: 5px;">
<?php
    if (isset($HTTP_GET_VARS['add_id']) && ($HTTP_GET_VARS['add_id'] != $cInfo->customers_default_address_id)) { // if not default address
      echo '<b>' . TEXT_INFO_HEADING_DELETE_ADDRESS .'</b>' .
           '<br> '. TEXT_DELETE_CUSTOMER_ADDRESS . '<br><b> ' . $cInfo->customers_firstname . ' ' . $cInfo->customers_lastname.'</b><br>' .
           tep_address_label($cInfo->customers_id, $HTTP_GET_VARS['add_id'], true, '', '<br>') . '<br>' .
           '<a class="splitPageLink" href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action','add_id')) . 'cID=' . $cInfo->customers_id . '&amp;action=confirmaddressdelete&amp;add_id=' . $HTTP_GET_VARS['add_id']) . '">' . TEXT_DELETE_ADDRESS . '</a>&nbsp;/&nbsp;' .
           '<a class="splitPageLink" href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action')) . 'cID=' . $cInfo->customers_id . '&amp;action=edit') . '">' . TEXT_DELETE_ADDRESS_CANCEL . '</a>';
    } else {
      echo '<b>' . TEXT_DELETE_ADDRESS_ERROR .'</b>&nbsp;' .
           '<a class="splitPageLink" href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action')) . 'cID=' . $cInfo->customers_id . '&amp;action=edit') . '">' . TEXT_DELETE_ADDRESS_CANCEL . '</a>';
    }
?>
              </div></td>
            </tr>
<?php
}
?>

            <tr>
              <td>
                <?php echo tep_draw_form('customers', FILENAME_CUSTOMERS, tep_get_all_get_params(array('action')) . 'action=update', 'post', 'onSubmit="return check_form();"');
                      echo tep_draw_hidden_field('default_address_id', $cInfo->customers_default_address_id); ?>
                  <table border="0" cellspacing="2" cellpadding="0">
                    <tr>
                      <td class="formAreaTitle"><?php echo CATEGORY_PERSONAL; ?></td>
                    </tr>
                    <tr>
                      <td class="formArea">
                        <table border="0" cellspacing="2" cellpadding="2">
<?php
    if (ACCOUNT_GENDER == 'true') {
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_GENDER; ?></td>
                            <td class="main"><?php
    if ($error == true) {
      if ($entry_gender_error == true) {
        echo tep_draw_radio_field('customers_gender', 'm', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . tep_draw_radio_field('customers_gender', 'f', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . FEMALE . '&nbsp;' . ENTRY_GENDER_ERROR;
      } else {
        echo ($cInfo->customers_gender == 'm') ? MALE : FEMALE;
        echo tep_draw_hidden_field('customers_gender');
      }
    } else {
      echo tep_draw_radio_field('customers_gender', 'm', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . tep_draw_radio_field('customers_gender', 'f', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . FEMALE;
    }
?></td>
                          </tr>
<?php
    }
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_FIRST_NAME; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_firstname_error == true) {
      echo tep_draw_input_field('customers_firstname', $cInfo->customers_firstname, 'maxlength="32"') . '&nbsp;' . ENTRY_FIRST_NAME_ERROR;
    } else {
      echo $cInfo->customers_firstname . tep_draw_hidden_field('customers_firstname');
    }
  } else {
    echo tep_draw_input_field('customers_firstname', $cInfo->customers_firstname, 'maxlength="32"', true);
  }
?></td>
                          </tr>
                          <tr>
                            <td class="main"><?php echo ENTRY_LAST_NAME; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_lastname_error == true) {
      echo tep_draw_input_field('customers_lastname', $cInfo->customers_lastname, 'maxlength="32"') . '&nbsp;' . ENTRY_LAST_NAME_ERROR;
    } else {
      echo $cInfo->customers_lastname . tep_draw_hidden_field('customers_lastname');
    }
  } else {
    echo tep_draw_input_field('customers_lastname', $cInfo->customers_lastname, 'maxlength="32"', true);
  }
?></td>
                          </tr>
<?php
    if (ACCOUNT_DOB == 'true') {
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_DATE_OF_BIRTH; ?></td>
                            <td class="main"><?php
    if ($error == true) {
      if ($customers_date_of_birth_error == true) {
        echo tep_draw_input_field('customers_dob', tep_date_short($cInfo->customers_dob), 'maxlength="10"') . '&nbsp;' . ENTRY_DATE_OF_BIRTH_ERROR;
      } else {
        echo $cInfo->customers_dob . tep_draw_hidden_field('customers_dob');
      }
    } else {
      echo tep_draw_input_field('customers_dob', tep_date_short($cInfo->customers_dob), 'maxlength="10"', true);
    }
?></td>
                          </tr>
<?php
    }
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_EMAIL_ADDRESS; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($customers_email_address_error == true) {
      echo tep_draw_input_field('customers_email_address', $cInfo->customers_email_address, 'maxlength="96"') . '&nbsp;' . ENTRY_EMAIL_ADDRESS_ERROR;
    } elseif ($customers_email_address_check_error == true) {
      echo tep_draw_input_field('customers_email_address', $cInfo->customers_email_address, 'maxlength="96"') . '&nbsp;' . ENTRY_EMAIL_ADDRESS_CHECK_ERROR;
    } elseif ($customers_email_address_exists == true) {
      echo tep_draw_input_field('customers_email_address', $cInfo->customers_email_address, 'maxlength="96"') . '&nbsp;' . ENTRY_EMAIL_ADDRESS_ERROR_EXISTS;
    } else {
      echo $customers_email_address . tep_draw_hidden_field('customers_email_address');
    }
  } else {
    echo tep_draw_input_field('customers_email_address', $cInfo->customers_email_address, 'maxlength="96"', true);
  }
?></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr>
                      <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
                    </tr>

                    <tr>
                      <td class="formAreaTitle"><?php echo CATEGORY_ADDRESS; ?></td>
                    </tr>
                    <tr>
                      <td class="formArea">
                        <table border="0" cellspacing="2" cellpadding="2">
                          <tr>
                            <td colspan="2">
                              <table border="0" cellspacing="0" cellpadding="2">
<!-- Admin edit any customer address begin //-->
<?php
  if ($action != 'update') { // only display if no update entry error
?>
                          <tr>
                            <td class="formAreaTitle">
<?php
$afl = array();
foreach ($aid_list as $a) {
  $afl[] = array('id' => tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('add_id', 'action')) . 'add_id=' . $a . '&amp;action=edit'),
                 'text' => $a);
}
 echo SELECT_ADDRESS . tep_draw_pull_down_menu('add_id', $afl, tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('add_id', 'action')) . 'add_id=' . (isset($HTTP_GET_VARS['add_id']) ? $HTTP_GET_VARS['add_id'] : $cInfo->customers_default_address_id) .'&amp;action=edit'), 'ONCHANGE="location = this.options[this.selectedIndex].value;"'); ?>
                            </td>
                            <td class="smallText"><?php
if (isset($HTTP_GET_VARS['add_id']) && ($HTTP_GET_VARS['add_id'] != $cInfo->customers_default_address_id)) { // if not default address
  echo '<a href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action')) . 'cID=' . $cInfo->customers_id . '&amp;action=deladdress') . '">' . DELETE_ADDRESS . '</a>';
} else {
  echo TEXT_DELETE_MAIN_ADDRESS;
}

?></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr>
                      <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
                    </tr>

<?php
  }
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_FIRST_NAME; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_firstname_error == true) {
      echo tep_draw_input_field('entry_firstname', $cInfo->entry_firstname, 'maxlength="32"') . '&nbsp;' . ENTRY_FIRST_NAME_ERROR;
    } else {
      echo $cInfo->entry_firstname . tep_draw_hidden_field('entry_firstname');
    }
  } else {
    echo tep_draw_input_field('entry_firstname', $cInfo->entry_firstname, 'maxlength="32"', true);
  }
?></td>
                          </tr>
                          <tr>
                            <td class="main"><?php echo ENTRY_LAST_NAME; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_lastname_error == true) {
      echo tep_draw_input_field('entry_lastname', $cInfo->entry_lastname, 'maxlength="32"') . '&nbsp;' . ENTRY_LAST_NAME_ERROR;
    } else {
      echo $cInfo->entry_lastname . tep_draw_hidden_field('entry_lastname');
    }
  } else {
    echo tep_draw_input_field('entry_lastname', $cInfo->entry_lastname, 'maxlength="32"', true);
  }
?></td>
                          </tr>
 <?php
  if (ACCOUNT_COMPANY == 'true') {
?>
                         <tr>
                            <td class="main"><?php echo ENTRY_COMPANY; ?></td>
                            <td class="main"><?php
    if ($error == true) {
      if ($entry_company_error == true) {
        echo tep_draw_input_field('entry_company', $cInfo->entry_company, 'maxlength="32"') . '&nbsp;' . ENTRY_COMPANY_ERROR;
      } else {
        echo $cInfo->entry_company . tep_draw_hidden_field('entry_company');
      }
    } else {
      echo tep_draw_input_field('entry_company', $cInfo->entry_company, 'maxlength="32"');
    }
?></td>
                          </tr><!-- Ajout pour TVA_INTRACOM_v3.3	//-->
          <tr>
            <td class="main" valign="top"><?php echo ENTRY_TVA_INTRACOM; ?></td>
            <td class="main">
<?php
		if ( ENTRY_TVA_INTRACOM_CHECK == 'true')	{
			if ($error == true) {
				if ($entry_tva_intracom_error == 'true') {
					echo tep_draw_input_field('entry_tva_intracom', $cInfo->entry_tva_intracom, 'maxlength="32"') . '&nbsp;' . ENTRY_CONTROL_TVA_INTRACOM ;
				} 
				if ($entry_tva_intracom_error == 'no_verif') {
					echo tep_draw_input_field('entry_tva_intracom', '', 'maxlength="32"') . '&nbsp;' . ENTRY_NO_VERIF_TVA_INTRACOM;
				} 
				if ($entry_tva_intracom_error == 'false') {
					echo $cInfo->entry_tva_intracom . tep_draw_hidden_field('entry_tva_intracom');
				}
			} else {
				echo tep_draw_input_field('entry_tva_intracom', $cInfo->entry_tva_intracom, 'maxlength="32"');
			}
		} else {
			if ($error == true) {
				if ($entry_tva_intracom_error == 'true') {
					echo tep_draw_input_field('entry_tva_intracom', $cInfo->entry_tva_intracom, 'maxlength="32"') . '&nbsp;' . ENTRY_TVA_INTRACOM_ERROR;
				} else {
					echo $cInfo->entry_tva_intracom . tep_draw_hidden_field('entry_tva_intracom');
				}
			} else {
                                echo tep_draw_input_field('entry_tva_intracom', $cInfo->entry_tva_intracom, 'maxlength="32"');
                        }
		}		
?>					</td>
          </tr>
	<!-- Fin ajout pour TVA_INTRACOM_v3.3	//-->
<?php
  }
?>
<!-- Admin edit any customer address end //-->
                          <tr>
                            <td class="main"><?php echo ENTRY_STREET_ADDRESS; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_street_address_error == true) {
      echo tep_draw_input_field('entry_street_address', $cInfo->entry_street_address, 'maxlength="64"') . '&nbsp;' . ENTRY_STREET_ADDRESS_ERROR;
    } else {
      echo $cInfo->entry_street_address . tep_draw_hidden_field('entry_street_address');
    }
  } else {
    echo tep_draw_input_field('entry_street_address', $cInfo->entry_street_address, 'maxlength="64"', true);
  }
?></td>
                          </tr>
<?php
    if (ACCOUNT_SUBURB == 'true') {
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_SUBURB; ?></td>
                            <td class="main"><?php
    if ($error == true) {
      if ($entry_suburb_error == true) {
        echo tep_draw_input_field('suburb', $cInfo->entry_suburb, 'maxlength="32"') . '&nbsp;' . ENTRY_SUBURB_ERROR;
      } else {
        echo $cInfo->entry_suburb . tep_draw_hidden_field('entry_suburb');
      }
    } else {
      echo tep_draw_input_field('entry_suburb', $cInfo->entry_suburb, 'maxlength="32"');
    }
?></td>
                          </tr>
<?php
    }
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_POST_CODE; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_post_code_error == true) {
      echo tep_draw_input_field('entry_postcode', $cInfo->entry_postcode, 'maxlength="8"') . '&nbsp;' . ENTRY_POST_CODE_ERROR;
    } else {
      echo $cInfo->entry_postcode . tep_draw_hidden_field('entry_postcode');
    }
  } else {
    echo tep_draw_input_field('entry_postcode', $cInfo->entry_postcode, 'maxlength="8"', true);
  }
?></td>
                          </tr>
                          <tr>
                            <td class="main"><?php echo ENTRY_CITY; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_city_error == true) {
      echo tep_draw_input_field('entry_city', $cInfo->entry_city, 'maxlength="32"') . '&nbsp;' . ENTRY_CITY_ERROR;
    } else {
      echo $cInfo->entry_city . tep_draw_hidden_field('entry_city');
    }
  } else {
    echo tep_draw_input_field('entry_city', $cInfo->entry_city, 'maxlength="32"', true);
  }
?></td>
                          </tr>
<?php
  if (ACCOUNT_STATE == 'true') {
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_STATE; ?></td>
                            <td class="main"><?php
    $entry_state = tep_get_zone_name($cInfo->entry_country_id, $cInfo->entry_zone_id, $cInfo->entry_state);
    if ($error == true) {
      if ($entry_state_error == true) {
        if ($entry_state_has_zones == true) {
          $zones_array = array();
          $zones_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . tep_db_input($cInfo->entry_country_id) . "' order by zone_name");
          while ($zones_values = tep_db_fetch_array($zones_query)) {
            $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
          }
          echo tep_draw_pull_down_menu('entry_state', $zones_array) . '&nbsp;' . ENTRY_STATE_ERROR;
        } else {
          echo tep_draw_input_field('entry_state', tep_get_zone_name($cInfo->entry_country_id, $cInfo->entry_zone_id, $cInfo->entry_state)) . '&nbsp;' . ENTRY_STATE_ERROR;
        }
      } else {
        echo $entry_state . tep_draw_hidden_field('entry_zone_id') . tep_draw_hidden_field('entry_state');
      }
    } else {
      echo tep_draw_input_field('entry_state', tep_get_zone_name($cInfo->entry_country_id, $cInfo->entry_zone_id, $cInfo->entry_state));
    }
?></td>
                          </tr>
<?php
  }
?>
                          <tr>
                            <td class="main"><?php echo ENTRY_COUNTRY; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_country_error == true) {
      echo tep_draw_pull_down_menu('entry_country_id', tep_get_countries(), $cInfo->entry_country_id) . '&nbsp;' . ENTRY_COUNTRY_ERROR;
    } else {
      echo tep_get_country_name($cInfo->entry_country_id) . tep_draw_hidden_field('entry_country_id');
    }
  } else {
    echo tep_draw_pull_down_menu('entry_country_id', tep_get_countries(), $cInfo->entry_country_id);
  }
?></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr>
                      <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
                    </tr>

                    <tr>
                      <td class="formAreaTitle"><?php echo CATEGORY_CONTACT; ?></td>
                    </tr>
                    <tr>
                      <td class="formArea">
                        <table border="0" cellspacing="2" cellpadding="2">
                          <tr>
                            <td class="main"><?php echo ENTRY_TELEPHONE_NUMBER; ?></td>
                            <td class="main"><?php
  if ($error == true) {
    if ($entry_telephone_error == true) {
      echo tep_draw_input_field('customers_telephone', $cInfo->customers_telephone, 'maxlength="32"') . '&nbsp;' . ENTRY_TELEPHONE_NUMBER_ERROR;
    } else {
      echo $cInfo->customers_telephone . tep_draw_hidden_field('customers_telephone');
    }
  } else {
    echo tep_draw_input_field('customers_telephone', $cInfo->customers_telephone, 'maxlength="32"', true);
  }
?></td>
                          </tr>
                          <tr>
                            <td class="main"><?php echo ENTRY_FAX_NUMBER; ?></td>
                            <td class="main"><?php
  if ($processed == true) {
    echo $cInfo->customers_fax . tep_draw_hidden_field('customers_fax');
  } else {
    echo tep_draw_input_field('customers_fax', $cInfo->customers_fax, 'maxlength="32"');
  }
?></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr>
                      <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
                    </tr>

                    <tr>
                      <td class="formAreaTitle"><?php echo CATEGORY_OPTIONS; ?></td>
                    </tr>
                    <tr>
                      <td class="formArea">
                        <table border="0" cellspacing="2" cellpadding="2">
                          <tr>
                            <td class="main"><?php echo ENTRY_NEWSLETTER; ?></td>
                            <td class="main"><?php
  if ($processed == true) {
    if ($cInfo->customers_newsletter == '1') {
      echo ENTRY_NEWSLETTER_YES;
    } else {
      echo ENTRY_NEWSLETTER_NO;
    }
    echo tep_draw_hidden_field('customers_newsletter');
  } else {
    echo tep_draw_pull_down_menu('customers_newsletter', $newsletter_array, (($cInfo->customers_newsletter == '1') ? '1' : '0'));
  }
?></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr>
                      <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
                    </tr>
                    <tr>
                      <td align="right" class="main"><?php echo tep_image_submit('button_update.gif', IMAGE_UPDATE) . ' <a href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('action'/*Admin edit any customer address*/, 'add_id'/*Admin edit any customer address*/))) .'">' . tep_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>'; ?></td>
                    </tr>
                  </table>
                </form>
              </td>
            </tr>
<?php
  } else {
//
// List customer information
//
?>
            <tr>
              <td>
                <table border="0" width="100%" cellspacing="0" cellpadding="0">
                  <tr>
                    <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
<?php if ($has_create_account) { ?>
<!-- bof updated customer list create new customer            -->             
                    <td class="pageHeading"><?php echo IMAGE_CREATE_CUSTOMER . '<a href="' . tep_href_link(FILENAME_CREATE_ACCOUNT ) . '">' . tep_image(DIR_WS_IMAGES . 'create_customer.png', IMAGE_CREATE_CUSTOMER) . '</a>'; ?></td>
<!-- eof updated customer list create new customer            -->             
<?php } ?>
                    <td class="smallText" align="right">
                      <?php echo tep_draw_form('search', FILENAME_CUSTOMERS, '', 'get') . "\n"; ?>
                        <?php echo HEADING_TITLE_SEARCH . ' ' . tep_draw_input_field('search') . "\n"; ?>
                      </form>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>

<?php
  if($action == 'confirm') {
?>
            <tr>
              <td width="100%"><div class="messageStackWarning" style="margin: 1em 0; padding: 5px;">
<?php echo '<b>' . TEXT_INFO_HEADING_DELETE_CUSTOMER .'</b>' .
           '<br> '. TEXT_DELETE_CUSTOMER . ' <b> ' . $cInfo->customers_firstname . ' ' . $cInfo->customers_lastname.'</b>&nbsp;' .
           '<a class="splitPageLink" href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action')) . 'cID=' . $cInfo->customers_id . '&amp;action=deleteconfirm') . '">' . TEXT_DELETE_ACCOUNT . '</a>&nbsp;/&nbsp;' .
           '<a class="splitPageLink" href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action'))) . '">' . TEXT_DELETE_ACCOUNT_CANCEL . '</a>';?>
              </div></td>
            </tr>
<?php
}
/*
Function to print table headers based on current sort pattern
$name = Full name of header, usually defined in language files
$id = sort word used in URL
$current_dir = current sort direction (ASC or DESC)
*/
function print_sort( $name, $id, $default_sort ) {
   global $orderby, $sort;

   if( isset( $orderby ) && ( $orderby == $id ) ) {
      if( $sort == 'ASC' ) {
         $to_sort = 'DESC';
      } else {
         $to_sort = 'ASC';
      }
   } else {
      $to_sort = $default_sort;
   }
   $return = '<a href="' . tep_href_link(FILENAME_CUSTOMERS, 'orderby=' . $id . '&amp;sort='. $to_sort) .
   '" class="headerLink">' . $name . '</a>';
   if( $orderby == $id ) {
      $return .= '&nbsp;<img src="images/arrow_' . ( ( $to_sort == 'DESC' ) ? 'down' : 'up' ) .
      '.png" width="10" height="13" border="0" alt="" >';
   }
   return $return;
}
?>
            <tr>
              <td valign="top">
                <table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr class="dataTableHeadingRow">
                    <td class="dataTableHeadingContent" align="left"><?php echo TABLE_HEADING_ACTIONS; ?></td>
                    <td class="dataTableHeadingContent" nowrap><?php echo print_sort(TABLE_HEADING_FIRSTNAME, 'firstname', 'ASC'); ?></td>
                    <td class="dataTableHeadingContent" nowrap><?php echo print_sort(TABLE_HEADING_LASTNAME, 'lastname', 'ASC'); ?></td>
                    <td class="dataTableHeadingContent" align="center"><?php echo print_sort(TABLE_HEADING_ACCOUNT_CREATED, 'date_created', 'DESC'); ?></td>
                    <td class="dataTableHeadingContent" align="center"><?php echo print_sort(TABLE_HEADING_LAST_LOGIN, 'date_login', 'DESC'); ?></td>
                    <td class="dataTableHeadingContent" align="center"><?php echo print_sort(TABLE_HEADING_NUM_LOGINS, 'num_logins', 'DESC'); ?></td>
                    <td class="dataTableHeadingContent" align="center"><?php echo TABLE_HEADING_TELEPHONE; ?></td>
<?php if (ACCOUNT_DOB == 'true') { ?>
                    <td class="dataTableHeadingContent" align="center"><?php echo print_sort(TABLE_HEADING_DOB, 'dob', 'ASC'); ?></td>
<?php } ?>
                    <td class="dataTableHeadingContent" align="center"><?php echo print_sort(TABLE_HEADING_LOCATION, 'state', 'ASC'); ?></td>
                    <td class="dataTableHeadingContent" align="center"><?php echo print_sort(TABLE_HEADING_NEWSLETTER, 'newsletter', 'ASC'); ?></td>
                  </tr>
<?php

$search = '';

// Setup column sorting
if($orderby == 'lastname') {
   $db_orderby = 'c.customers_lastname ' . $sort . ', c.customers_firstname';
} elseif($orderby == 'firstname') {
   $db_orderby = 'c.customers_firstname ' . $sort . ', c.customers_lastname';
} elseif($orderby == 'date_created') {
   $db_orderby = 'date_account_created ' . $sort . ', c.customers_lastname';
} elseif($orderby == 'date_login') {
   $db_orderby = 'last_logon ' . $sort . ', c.customers_lastname';
} elseif($orderby == 'num_logins') {
   $db_orderby = 'num_logons ' . $sort . ', c.customers_lastname';
} elseif($orderby == 'dob') {
   $db_orderby = 'customers_dob ' . $sort . ', c.customers_lastname';
} elseif($orderby == 'state') {
   $db_orderby = 'country ' . $sort . ', state ' . $sort . ', city ' . $sort . ', c.customers_lastname';
} elseif($orderby == 'newsletter') {
	$db_orderby = 'c.customers_newsletter ' . $sort . ', date_account_created';	
} else {
   $db_orderby = 'c.customers_lastname ASC, c.customers_firstname';
}
if(!$sort) $sort = 'ASC';

    if (isset($HTTP_GET_VARS['search']) && tep_not_null($HTTP_GET_VARS['search'])) {
      $keywords = tep_db_input(tep_db_prepare_input($HTTP_GET_VARS['search']));
      $search = "where c.customers_lastname like '%" . $keywords . "%' or c.customers_firstname like '%" . $keywords . "%' or c.customers_email_address like '%" . $keywords . "%'";
    }
    $customers_query_raw = "select c.customers_id, c.customers_lastname, c.customers_firstname, c.customers_email_address, c.customers_telephone, c.customers_dob, ci.customers_info_date_of_last_logon as last_logon, ci.customers_info_number_of_logons as num_logons, ci.customers_info_date_account_created as date_account_created, a.entry_city as city, a.entry_state as state_alt, z.zone_name as state, ctry.countries_iso_code_2 as country, c.customers_newsletter, a.entry_country_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on c.customers_id = a.customers_id and c.customers_default_address_id = a.address_book_id left join " . TABLE_CUSTOMERS_INFO . " ci on c.customers_id = ci.customers_info_id left join " . TABLE_COUNTRIES . " ctry on a.entry_country_id = ctry.countries_id left join " . TABLE_ZONES . " z on a.entry_zone_id = z.zone_id " . $search . " order by " . $db_orderby . " " . $sort;
    $customers_split = new splitPageResults($HTTP_GET_VARS['page'], MAX_DISPLAY_SEARCH_RESULTS, $customers_query_raw, $customers_query_numrows);
    $customers_query = tep_db_query($customers_query_raw);
    while ($customers = tep_db_fetch_array($customers_query)) {
      $info_query = tep_db_query("select customers_info_date_account_created as date_account_created, customers_info_date_account_last_modified as date_account_last_modified, customers_info_date_of_last_logon as date_last_logon, customers_info_number_of_logons as number_of_logons from " . TABLE_CUSTOMERS_INFO . " where customers_info_id = '" . $customers['customers_id'] . "'");
      $info = tep_db_fetch_array($info_query);

      if ((!isset($HTTP_GET_VARS['cID']) || (isset($HTTP_GET_VARS['cID']) && ($HTTP_GET_VARS['cID'] == $customers['customers_id']))) && !isset($cInfo)) {
        $country_query = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$customers['entry_country_id'] . "'");
        $country = tep_db_fetch_array($country_query);

        $reviews_query = tep_db_query("select count(*) as number_of_reviews from " . TABLE_REVIEWS . " where customers_id = '" . (int)$customers['customers_id'] . "'");
        $reviews = tep_db_fetch_array($reviews_query);

        $customer_info = array_merge($country, $info, $reviews);

        $cInfo_array = array_merge($customers, $customer_info);
        $cInfo = new objectInfo($cInfo_array);
      }
?>
                  <tr class="dataTableRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
                    <td><?php echo
        '<a href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action')) . 'cID=' . $customers['customers_id'] . '&amp;action=edit') . '">' . tep_image(DIR_WS_IMAGES . 'edit.png', IMAGE_EDIT) . '</a> | '.
        '<a href="' . tep_href_link(FILENAME_CUSTOMERS, tep_get_all_get_params(array('cID', 'action')) . 'cID=' . $customers['customers_id'] . '&amp;action=confirm') . '">' . tep_image(DIR_WS_IMAGES . 'delete.png', IMAGE_DELETE) . '</a> | '. 
        '<a href="' . tep_href_link(FILENAME_ORDERS, 'cID=' . $customers['customers_id']) . '">' . tep_image(DIR_WS_IMAGES . 'orders.png', IMAGE_ORDERS) . '</a> | ';
        if ($has_create_order) { 
          echo '<a href="' . tep_href_link(FILENAME_CREATE_ORDER, 'Customer=' . $customers['customers_id']) . '">' . tep_image(DIR_WS_IMAGES . 'manual_orders.png', IMAGE_MANUAL_ORDER_MAKER) . '</a> | ';
        }
        if ($has_change_password) {
          echo '<a href="' .  tep_href_link(FILENAME_CHANGE_PASSWORD,'selected_box=tools&amp;customer=' . $customers[ 'customers_id' ]) . '">' . tep_image(DIR_WS_IMAGES . 'change_password.png', IMAGE_CHANGE_PASSWORD) . '</a> | ';      
        }
        echo '<a href="' . tep_href_link(FILENAME_MAIL, 'selected_box=tools&amp;customer=' . $customers['customers_email_address']) . '">' . tep_image(DIR_WS_IMAGES . 'email_send.png', IMAGE_EMAIL) . '</a>';
        ?>
                    </td>
                    <td class="dataTableContent"><?php echo htmlspecialchars($customers['customers_firstname']); ?></td>
                    <td class="dataTableContent"><?php echo htmlspecialchars($customers['customers_lastname']); ?></td>
                    <td class="dataTableContent" align="center"><?php echo tep_date_short($customers['date_account_created']); ?></td>
                    <td class="dataTableContent" align="center"><?php echo tep_date_short($info['date_last_logon']); ?></td>
                    <td class="dataTableContent" align="center"><?php 
                    if($info['number_of_logons'] == -1){
                      echo TEXT_NUM_LOGINS_GUEST;
                    }
                    else{
                         echo ($info['number_of_logons']); 
                    }?></td>
                    <td class="dataTableContent" align="center"><?php echo htmlspecialchars($customers['customers_telephone']); ?></td>
<?php if (ACCOUNT_DOB == 'true') { ?>
                    <td class="dataTableContent"><?php echo tep_date_short($customers['customers_dob']); ?></td>
<?php } ?>
                    <td class="dataTableContent" align="center"><?php
        echo htmlspecialchars($customers['country'] ? $customers['country'] : '<font color="#808080">' . TEXT_VOID . '</font>') . ', ';
        if( isset($customers['state']) ) {
           echo htmlspecialchars(html_entity_decode(ucwords($customers['state'])));
        } else if( ! empty($customers['state_alt']) ) {
           echo htmlspecialchars(html_entity_decode(ucwords($customers['state_alt'])));
        } else {
           echo '<font color="#808080">' . TEXT_VOID . '</font>';
        }
        echo ', ' . htmlspecialchars(ucwords(($customers['city'] ? $customers['city'] : '<font color="#808080">' . TEXT_VOID . '</font>'))); 
?></td>
                    <td class="dataTableContent"><div align="center">
                      <?php if ($customers['customers_newsletter'] > '0') {
          echo '<font color="#00CC33"><strong>' . ENTRY_NEWSLETTER_YES . '</strong></font>' . "\n";
        } else {
          echo '<font color="#FF0000"><strong>' . ENTRY_NEWSLETTER_NO . '</strong></font>' . "\n";
        }?>
                    </div></td>
<?php
    }
?>
                  </tr>
                  <tr>
                    <td colspan="10">
                      <table border="0" width="100%" cellspacing="0" cellpadding="2">
                        <tr>
                          <td class="smallText" valign="top"><?php echo $customers_split->display_count($customers_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $HTTP_GET_VARS['page'], TEXT_DISPLAY_NUMBER_OF_CUSTOMERS); ?></td>
                          <td class="smallText" align="right"><?php echo $customers_split->display_links($customers_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $HTTP_GET_VARS['page'], tep_get_all_get_params(array('page', 'info', 'x', 'y', 'cID'))); ?></td>
                        </tr>
<?php
  if (isset($HTTP_GET_VARS['search']) && tep_not_null($HTTP_GET_VARS['search'])) {
?>
                        <tr>
                          <td align="right" colspan="2"><?php echo '<a href="' . tep_href_link(FILENAME_CUSTOMERS) . '">' . tep_image_button('button_reset.gif', IMAGE_RESET) . '</a>'; ?></td>
                        </tr>
<?php
  }
?>
                      </table>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
<?php
  }
?>
          </table>
        </td>
<!-- body_text_eof //-->
      </tr>
    </table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
    <br>
  </body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
