<?php
//----------------------------------------------------------------------
//  CrawlProtect 2.0.0
//----------------------------------------------------------------------
// Protect your website from hackers
//----------------------------------------------------------------------
// Author: Jean-Denis Brun
//----------------------------------------------------------------------
// Website: www.crawlprotect.com
//----------------------------------------------------------------------
// That script is distributed under GNU GPL license
//----------------------------------------------------------------------
// file: function.php
//----------------------------------------------------------------------
//  Last update: 03/07/2010
//----------------------------------------------------------------------

//functions to format numbers for display	
function numbdisp($value)
	{
	$value = number_format($value,0,".",",");
	return $value;
	}
function numbdisp2($value)
	{
	$value = number_format($value,1,".",",");
	return $value;
	}
//function for looking for file
function lookfile($dirname, $whichfile,$justbad,$nocache,$nostats,$nologs)
    	{
	global $goodfilechmod;
	$list=array();
	$today=strtotime("today");
	$dir = opendir($dirname);
	while($file = readdir($dir))
		{
		if($dirname=='../')
			{
			$file2=$dirname.$file;
			}
		else
			{
			$file2=$dirname."/".$file;
			}

		if($whichfile=='all')
			{
			if($file != '.' && $file != '..' && !is_dir($file2))
				{
				$take=1;
				$timedir=filemtime($file2);			
				if($justbad=='ok')
					{											
					$perms=fileperms($file2);
					$chmod=substr(sprintf('%o', $perms), -4);
				
					if(($today-$timedir)> 604800 && in_array($chmod, $goodfilechmod))
						{
						$take++;			
						}				
					
					}
				if($nocache=='ok')
					{
					if(preg_match("/cache/i", $file2))
						{
						$take++;
						}
					}
				if($nostats=='ok')
					{
					if(preg_match("/stats/i", $file2))
						{
						$take++;
						}
					}
				if($nologs=='ok')
					{
					if(preg_match("/logs/i", $file2))
						{
						$take++;
						}
					}
				if($take==1)
					{
					$list[$file2]=$timedir;
					}
				}
			}
		else
			{
			if($file != '.' && $file != '..' && !is_dir($file2) && (preg_match("/htaccess/i", $file) OR preg_match("/index/i", $file) OR preg_match("/header/i", $file) OR preg_match("/footer/i", $file) OR preg_match("/config/i", $file)))
				{
				$take=1;
				$timedir=filemtime($file2);
				if($justbad=='ok')
					{		
					
					$perms=fileperms($file2);
					$chmod=substr(sprintf('%o', $perms), -4);
				
					if(($today-$timedir)> 604800 && in_array($chmod, $goodfilechmod))
						{
						$take++;			
						}				
					
					}
				if($nocache=='ok')
					{
					if(preg_match("/cache/i", $file2))
						{
						$take++;
						}
					}
				if($nostats=='ok')
					{
					if(preg_match("/stats/i", $file2))
						{
						$take++;
						}
					}
				if($nologs=='ok')
					{
					if(preg_match("/logs/i", $file2))
						{
						$take++;
						}
					}
				if($take==1)
					{
					$list[$file2]=$timedir;
					}
				}
			}
		}
	closedir($dir);
	return $list;
	} 

//function to have the list of folder
function lookfolder($dirname, $folderlevel,$justbad,$nocache,$nostats,$nologs)
    	{
	global $goodfolderchmod, $listallfolders;
	$list=array();
	$list0=array();
	$today=strtotime("today");
	$dir = opendir($dirname);
	//first level
	while($file = readdir($dir))
		{
		if($file != '.' && $file != '..' && is_dir($dirname.$file))
			{
			$take=1;
			$dir2="../".$file;				
			$timedir=filemtime($dir2);
			if($justbad=='ok')
				{
				$perms=fileperms($dir2);
				$chmod=substr(sprintf('%o', $perms), -4);
				
				if(($today-$timedir)> 604800 && in_array($chmod, $goodfolderchmod))
					{
					$take++;			
					}				
					
				}
			if($nocache=='ok')
				{
				if(preg_match("/cache/i", $file))
					{
					$take++;
					}
				}
			if($nostats=='ok')
				{
				if(preg_match("/stats/i", $file))
					{
					$take++;
					}
				}
			if($nologs=='ok')
				{
				if(preg_match("/logs/i", $file))
					{
					$take++;
					}
				}
			if($take==1)
				{
				$list[$file]=$timedir;
				}
			$listallfolders[$file]=$timedir;
			}
		}
	closedir($dir);
$search='go';
$i=1;
while ($search =='go' )
	{
	if($i==1)
		{
		$listtosearch=$listallfolders;
		}
	else
		{
		$listtosearch=$list3;
		$list2=array();
		$list3=array();
		}	

	foreach($listtosearch as $value=>$time)
		{
		$folder=$dirname.$value."/";
		$dir = opendir($folder);

		while($file = readdir($dir))
			{
			if($file != '.' && $file != '..' && is_dir($folder.$file))
				{
				$take=1;
				$dir2=$folder.$file;
				$timedir=filemtime($dir2);
				if($justbad=='ok')
					{
					$perms=fileperms($dir2);
					$chmod=substr(sprintf('%o', $perms), -4);
				
					if(($today-$timedir)> 604800 && in_array($chmod, $goodfolderchmod))
						{
						$take++;			
						}						
					}
				if($nocache=='ok')
					{
					if(preg_match("/cache/i", $file))
						{
						$take++;
						}
					}
				if($nostats=='ok')
					{
					if(preg_match("/stats/i", $file))
						{
						$take++;
						}
					}
				if($nologs=='ok')
					{
					if(preg_match("/logs/i", $file))
						{
						$take++;
						}
					}
				$key=$value."/".$file;
				if($take==1)
					{
					$list2[$key]=$timedir;
					}
				
				$list3[$key]=$timedir;
				}
			}
		closedir($dir);	
	
		}
	$list= array_merge($list,$list2);
	$listallfolders=array_merge($listallfolders,$list3);
	if(count($list2)>0 && $folderlevel!='restricted')
		{
		$search='go';
		}
	else
		{
		$search='stop';
		}
	$i++;
	}
	return $list;
	}
//function change chmod
function change_chmod($type2, $filedir, $chmod, $validchmod)
	{
	global $filelist, $dirlist, $language, $release, $languageuse, $min, $minf, $sort, $sortf,$listfiledontchange,$listfolderdontchange;

	if(($validchmod==1 && $chmod ==1) OR $chmod==0)
		{
		if($type2=='file')
			{
			if($chmod==1)
				{				
			       if(function_exists('chmod'))
					{
					if( $filedir !='changeallfiles')
						{
						chmod($filedir, 0404);
						}
					else
						{
						foreach($filelist as $key=>$value)
							{
							if(is_file($key) && !in_array($key, $listfiledontchange))
								{
						    		chmod($key, 0404);
								}
							}
						}
					}
				}
			elseif($chmod==0)
				{
			       if(function_exists('chmod'))
					{
					if( $filedir !='changeallfiles')
						{
						chmod($filedir, 0644);
						}
					else
						{
						foreach($filelist as $key=>$value)
							{
							if(is_file($key) && !in_array($key, $listfiledontchange))
								{
					    			chmod($key, 0644);
								}
							}
						}
					}
				}

			}
		elseif($type2=='folder')
			{
			if($chmod==1)
				{				
			       if(function_exists('chmod'))
					{
					if( $filedir !='changeallfolders')
						{
						chmod($filedir, 0505);
						}
					else
						{
						foreach($dirlist as $key=>$value)
							{
							$dir="../".$key;
							if(!in_array($dir, $listfolderdontchange))
								{								
				    				chmod($dir, 0505);
								}								
							}
						}
					}
				}
			elseif($chmod==0)
				{
			       if(function_exists('chmod'))
					{
					if( $filedir !='changeallfolders')
						{
						chmod($filedir, 0755);
						}
					else
						{
						foreach($dirlist as $key=>$value)
							{
							$dir="../".$key;
							if(!in_array($dir, $listfolderdontchange))
								{
								chmod($dir, 0755);
								}
							}

						}
					}
				}

			}
		}
	else
		{
		if($chmod==1)
			{
			if($type2=='file')
				{
				echo"<div  align=\"center\"><form action=\"index.php#files\" method=\"POST\" >\n";
				}
			else
				{
				echo"<div  align=\"center\"><form action=\"index.php#folders\" method=\"POST\" >\n";
				}
			$text7=$language['yes'];
			echo "<h1>".$language['chmod_safe']."</h1>";
			if($filedir=='changeallfiles')
				{
				echo "<h2>".$language['change_all_files']."</h2>";
				}
			elseif($filedir=='changeallfolders')
				{
				echo "<h2>".$language['change_all_folders']."</h2>";
				}
			else
				{
				echo "<h2>".$filedir."</h2>";
				}
			echo "<p class=\"red\">".$language['change-chmod-to-safe']."</p>";
			echo "<input type=\"hidden\" name ='navig' value='2'>\n";
			echo "<input type=\"hidden\" name ='datedisplay' value='0'>\n";	
			echo "<input type=\"hidden\" name ='changechmod' value='1'>\n";	
			echo "<input type=\"hidden\" name ='filedir' value='$filedir'>\n";
			echo "<input type=\"hidden\" name ='type2' value='$type2'>\n";
			echo "<input type=\"hidden\" name ='min' value='$min'>";
			echo "<input type=\"hidden\" name ='minf' value='$minf'>";
			echo "<input type=\"hidden\" name ='sort' value='$sort'>\n";	
			echo "<input type=\"hidden\" name ='sortf' value='$sortf'>\n";	
			echo "<input type=\"hidden\" name ='chmod' value='1'>\n";
			echo "<input type=\"hidden\" name ='validchmod' value='1'>\n";     
			echo"<br><input name='ok' type='submit'  class='widebutton' value='$text7' size='20' >\n";
			echo"</form><br>\n";	
			$text8=$language['no'];
			if($type2=='file')
				{
				echo"<form action=\"index.php#files\" method=\"POST\" >\n";
				}
			else
				{
				echo"<form action=\"index.php#folders\" method=\"POST\" >\n";
				}
			echo "<input type=\"hidden\" name ='navig' value='2'>\n";
			echo "<input type=\"hidden\" name ='min' value='$min'>";
			echo "<input type=\"hidden\" name ='minf' value='$minf'>";
			echo "<input type=\"hidden\" name ='sort' value='$sort'>\n";	
			echo "<input type=\"hidden\" name ='sortf' value='$sortf'>\n";
 			echo "<input type=\"hidden\" name ='datedisplay' value='0'>\n";	
			echo "<input type=\"hidden\" name ='validchmod' value='0'>\n";     
			echo"<input name='ok' type='submit'  class='widebutton' value='$text8' size='20' >\n";
			echo"</form></div><br>\n";
			include("sponsors.php");
			echo"<div class=\"footer\">\n";
			echo"<a href=\"http://www.crawlprotect.com\" onclick=\"window.open(this.href);return(false);\">\n";
			echo"CrawlProtect</a>\n";
			echo"</div>\n";
			echo"</div>\n";
			echo"</body>\n";
			echo"</html>\n";
			exit();
			}
		}
	}
//function to validate password
function valid_password($password) {
if(strlen($password)>7 && preg_match('`[A-Z]`',$password) && preg_match('`[a-z]`',$password) && preg_match('`[0-9]`',$password) )
	{
	return true;
	}
else
	{
	return false;
	} 
}

//function to put the page in cache (http://spellbook.infinitiv.it/2006/07/03/caching-your-queries-with-php.htm)

function cache($cachename)
	{  
	global $caching, $languageuse, $language, $type; 
	if($type=='file')
		{
		if( isset($_SESSION[$cachename]) && file_exists("./cache/$cachename.txt"))
			{
			//Grab the cache:
			include("./cache/$cachename.txt");
			include("sponsors.php");
			echo"<div class=\"footer\">\n";
			echo"<a href=\"http://www.crawlprotect.com\" onclick=\"window.open(this.href);return(false);\">\n";
			echo"CrawlProtect</a>\n";
			echo"</div>\n";
			echo"</div>\n";
			echo"</body>\n";
			echo"</html>\n";
			exit();
			}       
		else
			{
			//create cache :                  
			$caching = 'true';
			ob_start();
			}
		}     
	}
   
function close()
    	{
	global $caching, $cachename;
 
	//You should have this at the end of each page
	if ( $caching=='true')
		{    
		//You were caching the contents so display them, and write the cache file
		$data = ob_get_contents();
		@ob_end_flush ();
		if(function_exists('chmod'))
			{
			chmod('./cache/', 0755);
			}
		$fp = fopen( "./cache/$cachename.txt" , 'w' );
		fwrite ( $fp , $data );         
		fclose ( $fp );
		$_SESSION[$cachename]='ok';  
		}     
  	}
//function to cut and wrap the url to avoid oversize display	
function crawltcuturl($url,$length)
    {
    $urldisplaylength = strlen("$url");
    $cutvalue = 0;
    $urldisplay='';
    while ($cutvalue <= $urldisplaylength)
        {
        $cutvalue2 = $cutvalue + $length;
        $urldisplay= $urldisplay.htmlspecialchars(substr($url,$cutvalue,$length));
        if ($cutvalue2 <= $urldisplaylength)
            {
            $urldisplay = $urldisplay.'...<br>&nbsp;&nbsp;...';
            $urlcut=1;
            }
        $cutvalue = $cutvalue2;
        } 
   
     return  $urldisplay;             
     } 

?>
