<?php
/*
  $Id: international.php,v 1.0 2005/10/23 Fred SIMON Exp $
  www.oscommerce-fr.info
  
  The Exchange Project - Community Made Shopping!
  http://www.oscommerce.com

  Copyright (c) 2000,2001 The Exchange Project

  Released under the GNU General Public License
  
  
*/

  class international {
    var $code, $title, $description, $enabled, $num_international;

// class constructor
    function international() {
      $this->code        = 'international';
      $this->title       = MODULE_SHIPPING_INTERNATIONAL_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_INTERNATIONAL_TEXT_DESCRIPTION;
      $this->sort_order  = MODULE_SHIPPING_INTERNATIONAL_SORT_ORDER;
      $this->icon        = DIR_WS_ICONS . 'colissimo.gif';
      $this->tax_class   = MODULE_SHIPPING_INTERNATIONAL_TAX_CLASS;
      $this->enabled     = ((MODULE_SHIPPING_INTERNATIONAL_STATUS == 'True') ? true : false);

      // CUSTOMIZE THIS SETTING FOR THE NUMBER OF international NEEDED
      $this->num_international = 6; //NBen je remplace 1 par 10

      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_INTERNATIONAL_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_INTERNATIONAL_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function quote() {
      global $order, $shipping_weight;

      $this->quotes = array('id'      => $this->code,
                            'module'  => MODULE_SHIPPING_INTERNATIONAL_TEXT_TITLE,
                            'methods' => array());

      if (tep_not_null($this->icon))
	$this->quotes['icon'] = tep_image($this->icon, $this->title);

      if ($this->tax_class > 0)
        $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);

      $dest_country = $order->delivery['country']['iso_code_2'];
      $dest_zone = 0;
      for ($i = 1; $i <= $this->num_international; $i ++) {
	$countries_table = constant('MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_' . $i);
	$country = split("[,]", $countries_table);
	if ( in_array($dest_country, $country ) ) {
	  $dest_zone = $i;
	  break;
	}
      }
      if ($dest_zone == 0) {
	$this->quotes['error'] = MODULE_SHIPPING_INTERNATIONAL_INVALID_ZONE;
	return $this->quotes;
      }

      $table = split("[:,]" , constant('MODULE_SHIPPING_INTERNATIONAL_COST_' . $dest_zone));
      $cost = -1;
      for ($i = 0, $n = sizeof($table); $i < $n; $i+=2) {
	if ($shipping_weight <= $table[$i]) {
	  $cost = $table[$i+1] + MODULE_SHIPPING_INTERNATIONAL_HANDLING + SHIPPING_HANDLING;
	  break;
	}
      }

      if ($cost == -1) {
	$this->quotes['error'] = MODULE_SHIPPING_INTERNATIONAL_UNDEFINED_RATE;
	return $this->quotes;
      }

      $this->quotes['methods'][] = array('id'    => $this->code,
					 'title' => MODULE_SHIPPING_INTERNATIONAL_TEXT_WAY . ' ' . $order->delivery['country']['title'],
					 'cost'  => $cost + MODULE_SHIPPING_INTERNATIONAL_HANDLING + SHIPPING_HANDLING);

      return $this->quotes;
    }

    function check() {
      if (!isset($this->check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_INTERNATIONAL_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }
      return $this->check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Activer Colissimo international', 'MODULE_SHIPPING_INTERNATIONAL_STATUS', 'True', 'Vous souhaitez activer l\'expdition via colissimo international? (0=non, 1=oui)', '6', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Les tarifs', 'MODULE_SHIPPING_INTERNATIONAL_HANDLING', '0', 'Les tarifs pour l\'expdition via colissimo international', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 1 (pays)', 'MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_1', 'DE,BE,NL', 'Insrer une virgule entre 2 codes ISO de pays qui font partie de la mme zone', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 1 (poids:tarifs)', 'MODULE_SHIPPING_INTERNATIONAL_COST_1', '1:11.00,2:11.50,3:12.00,4:12.50,5:13.00,6:13.50,7:14.00,8:14.50,9:15.00,10:15.50,15:18.00,20:20.50,25:23.00,30:25.50', 'Tarifs Colissimo international pour les destinations de la Zone 1. ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 2 (pays)', 'MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_2', 'GB,IT,ES', 'Insrer une virgule entre 2 codes ISO de pays qui font partie de la mme zone', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 2 (poids:tarifs)', 'MODULE_SHIPPING_INTERNATIONAL_COST_2', '1:13.30,2:13.90,3:14.50,4:12.50,5:13.00,6:13.50,7:14.00,8:14.50,9:15.00,10:15.50,15:18.00,20:20.50,25:23.00,30:25.50', 'Tarifs Colissimo international pour les destinations de la Zone 2. ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 3 (pays)', 'MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_3', 'AT,DK,IE,PT', 'Insrer une virgule entre 2 codes ISO de pays qui font partie de la mme zone', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 3 (poids:tarifs)', 'MODULE_SHIPPING_INTERNATIONAL_COST_3', '1:13.70,2:14.80,3:15.90,4:17.00,5:18.10,6:19.20,7:20.30,8:21.40,9:22.50,10:23.60,15:29.10,20:34.60,25:40.10,30:45.60', 'Tarifs Colissimo international pour les destinations de la Zone 3. ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 4 (pays)', 'MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_4', 'FI,NO,SE,CH', 'Insrer une virgule entre 2 codes ISO de pays qui font partie de la mme zone', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 4 (poids:tarifs)', 'MODULE_SHIPPING_INTERNATIONAL_COST_4', '1:17.70,2:18.70,3:19.70,4:20.70,5:21.70,6:22.70,7:23.70,8:24.70,9:25.70,10:26.70,15:31.70,20:36.70,25:41.70,30:46.70', 'Tarifs Colissimo international pour les destinations de la Zone 4. ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 5 (pays)', 'MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_5', 'GR,IS,PL', 'Insrer une virgule entre 2 codes ISO de pays qui font partie de la mme zone', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 5 (poids:tarifs)', 'MODULE_SHIPPING_INTERNATIONAL_COST_5', '1:18.00,2:21.30,3:24.60,4:27.90,5:31.20,6:34.50,7:37.80,8:41.10,9:44.40,10:47.70,15:59.70,20:71.70,25:83.70,30:95.70', 'Tarifs Colissimo international pour les destinations de la Zone 5. ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 6 (pays)', 'MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_6', 'US,CA', 'Insrer une virgule entre 2 codes ISO de pays qui font partie de la mme zone', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('INTERNATIONAL Zone 6 (poids:tarifs)', 'MODULE_SHIPPING_INTERNATIONAL_COST_6', '1:22.00,2:29.00,3:36.00,4:43.00,5:50.00,6:57.00,7:64.00,8:71.00,9:78.00,10:85.00,15:110.00,20:135.00,25:160.00,30:185.00', 'Tarifs Colissimo international pour les destinations de la Zone 6. ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Tax Class', 'MODULE_SHIPPING_INTERNATIONAL_TAX_CLASS', '0', 'Use the following tax class on the shipping fee.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Shipping Zone', 'MODULE_SHIPPING_INTERNATIONAL_ZONE', '0', 'If a zone is selected, only enable this shipping method for that zone.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort Order', 'MODULE_SHIPPING_INTERNATIONAL_SORT_ORDER', '0', 'Sort order of display.', '6', '0', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      $keys = array(
		    'MODULE_SHIPPING_INTERNATIONAL_STATUS',
		    'MODULE_SHIPPING_INTERNATIONAL_HANDLING',
		    'MODULE_SHIPPING_INTERNATIONAL_TAX_CLASS',
		    'MODULE_SHIPPING_INTERNATIONAL_ZONE',
		    'MODULE_SHIPPING_INTERNATIONAL_SORT_ORDER'
		    );
      for ($i = 1; $i <= $this->num_international; $i ++) {
        $keys[count($keys)] = 'MODULE_SHIPPING_INTERNATIONAL_COUNTRIES_' . $i;
        $keys[count($keys)] = 'MODULE_SHIPPING_INTERNATIONAL_COST_' . $i;
      }
      return $keys;
    }
  }
?>
