<?php
/**
 * $Id: $
 *
 * Released under the GNU General Public License
 */
class paypal_wpp_base {

    var $code, $title, $description, $enabled, $zone;

    function update_status() {
        global $order;

        if ($this->enabled && ($this->zone > 0)) {
            $check_flag = false;
            $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . $this->zone . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
            while ($check = tep_db_fetch_array($check_query)) {
                if ($check['zone_id'] < 1) {
                    $check_flag = true;
                    break;
                } elseif ($check['zone_id'] == $order->billing['zone_id']) {
                    $check_flag = true;
                    break;
                }
            }

            if (!$check_flag) {
                $this->enabled = false;
            }
        }
    }

    function javascript_validation() {
      global $paypal_ec_token, $paypal_ec_payer_id, $paypal_ec_payer_info;

      if (tep_session_is_registered('paypal_ec_token') && tep_session_is_registered('paypal_ec_payer_id') && tep_session_is_registered('paypal_ec_payer_info')) {
        return false;
      } else {
        $js = '  if (payment_value == "' . $this->code . '") {' . "\n" .
              '    var cc_firstname = document.checkout_payment.paypalwpp_cc_firstname.value;' . "\n" .
              '    var cc_lastname = document.checkout_payment.paypalwpp_cc_lastname.value;' . "\n" .
              '    var cc_number = document.checkout_payment.paypalwpp_cc_number.value;' . "\n" .
              '    var cc_checkcode = document.checkout_payment.paypalwpp_cc_number.value;' . "\n" .
              '    if (cc_firstname == "" || cc_lastname == "" || eval(cc_firstname.length) + eval(cc_lastname.length) < ' . CC_OWNER_MIN_LENGTH . ') {' . "\n" .
              '      error_message = error_message + "' . MODULE_PAYMENT_PAYPAL_DP_TEXT_JS_CC_OWNER . '";' . "\n" .
              '      error = 1;' . "\n" .
              '    }' . "\n" .
              '    if (cc_number == "" || cc_number.length < ' . CC_NUMBER_MIN_LENGTH . ') {' . "\n" .
              '      error_message = error_message + "' . MODULE_PAYMENT_PAYPAL_DP_TEXT_JS_CC_NUMBER . '";' . "\n" .
              '      error = 1;' . "\n" .
              '    }' . "\n" .
              '  }' . "\n";

        return $js;
      }
    }

    function selection() {
      if (!$this->enableDirectPayment) {
          return array('id' => $this->code,
                       'module' => MODULE_PAYMENT_PAYPAL_EC_TEXT_TITLE,
                       'noradio' => true,
                       'fields' => array(
                            array('title' => '',
                                 'field' => MODULE_PAYMENT_PAYPAL_EC_MARK_TEXT.'<a href="' . tep_href_link('ec_process.php', 'markflow=1&clearSess=1', 'SSL') . '"><img src="' . MODULE_PAYMENT_PAYPAL_BUTTON_IMG. '" align="top" border=0 style="padding-right:10px;padding-bottom:10px"></a>'.'</td>')));
                                 //'field' => '<a href="' . tep_href_link('ec_process.php', 'markflow=1&clearSess=1', 'SSL') . '"><img src="' . MODULE_PAYMENT_PAYPAL_BUTTON_IMG. '" align="top" border=0 style="padding-right:10px;padding-bottom:10px"></a>'.MODULE_PAYMENT_PAYPAL_EC_MARK_TEXT.'</td>')));
      }

      global $order;

      for ($i=1; $i < 13; $i++) {
        $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => strftime('%B',mktime(0,0,0,$i,1,2000)));
      }

      $today = getdate();
      for ($i=$today['year']; $i < $today['year']+10; $i++) {
        $expires_year[] = array('id' => strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => strftime('%Y',mktime(0,0,0,1,1,$i)));
      }

      $selection = array('id' => $this->code,
                         'module' => MODULE_PAYMENT_PAYPAL_DP_TEXT_TITLE,
                         'fields' => array(
                             array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_FIRSTNAME,
                                   'field' => tep_draw_input_field('paypalwpp_cc_firstname', $order->billing['firstname'])),
                             array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_LASTNAME,
                                   'field' => tep_draw_input_field('paypalwpp_cc_lastname', $order->billing['lastname'])),
                             array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_TYPE,
                                   'field' => tep_draw_pull_down_menu('paypalwpp_cc_type', $this->cards)),
                             array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_NUMBER,
                                   'field' => tep_draw_input_field('paypalwpp_cc_number', '')),
                             array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_EXPIRES,
                                   'field' => tep_draw_pull_down_menu('paypalwpp_cc_expires_month', $expires_month) . '&nbsp;' . tep_draw_pull_down_menu('paypalwpp_cc_expires_year', $expires_year)),
                             array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_CHECKNUMBER,
                                   'field' => tep_draw_input_field('paypalwpp_cc_checkcode', '', 'size="4" maxlength="4"') . '&nbsp;<small>' . MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_CHECKNUMBER_LOCATION . '</small>'),
                             array('title' => '<b>' . MODULE_PAYMENT_PAYPAL_DP_TEXT_EC_HEADER . '</b>',
                                   'field' => '<a href="' . tep_href_link('ec_process.php', 'markflow=1&clearSess=1', 'SSL') . '"><img src="' . MODULE_PAYMENT_PAYPAL_EC_BUTTON_IMG . '" border=0 style="padding-right:10px;padding-bottom:10px"></a><br><span style="font-size:11px; font-family: Arial, Verdana;">' . MODULE_PAYMENT_PAYPAL_DP_TEXT_BUTTON_TEXT . '</span></td>')));

      if (strtolower(get_class($this)) == 'paypal_wpp_uk') {
          for ($i = $today['year'] - 10; $i <= $today['year']; $i++) {
              $issue_year[] = array('id' => strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => strftime('%Y',mktime(0,0,0,1,1,$i)));
          }
          array_splice($selection['fields'], 4, 0, array(array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_ISSUE,
                                                               'field' => tep_draw_pull_down_menu('paypalwpp_cc_issue_month', $expires_month) . '&nbsp;' . tep_draw_pull_down_menu('paypalwpp_cc_issue_year', $issue_year))));
      }

      return $selection;
    }

    /**
     * This is the credit card check done between checkout_payment.php
     * and checkout_confirmation.php (called from
     * checkout_confirmation.php)
     */
    function pre_confirmation_check() {
        global $HTTP_POST_VARS, $paypal_ec_token, $paypal_ec_payer_id, $paypal_ec_payer_info;

        // If this is an EC checkout, do nothing.
        if (tep_session_is_registered('paypal_ec_token') && tep_session_is_registered('paypal_ec_payer_id') && tep_session_is_registered('paypal_ec_payer_info')) {
            return false;
        }

        include(dirname(__FILE__) . '/paypal_cc_validation.php');

        $cc_validation = new paypal_cc_validation();
        $result = $cc_validation->validate($HTTP_POST_VARS['paypalwpp_cc_number'], $HTTP_POST_VARS['paypalwpp_cc_expires_month'], $HTTP_POST_VARS['paypalwpp_cc_expires_year'],
                                           $HTTP_POST_VARS['paypalwpp_cc_issue_month'], $HTTP_POST_VARS['paypalwpp_cc_issue_year']);

        $error = '';
        switch ($result) {
        case -1:
            $error = sprintf(TEXT_CCVAL_ERROR_UNKNOWN_CARD, substr($cc_validation->cc_number, 0, 4));
            break;
        case -2:
        case -3:
        case -4:
            $error = TEXT_CCVAL_ERROR_INVALID_DATE;
            break;
        case false:
            $error = TEXT_CCVAL_ERROR_INVALID_NUMBER;
            break;
        }

        $HTTP_POST_VARS['paypalwpp_cc_checkcode'] = preg_replace('/[^0-9]/i', '', $HTTP_POST_VARS['paypalwpp_cc_checkcode']);

        if (($result === false) || ($result < 1) ) {
            $this->away_with_you(MODULE_PAYMENT_PAYPAL_DP_TEXT_CARD_ERROR . '<br><br>' . $error, false, FILENAME_CHECKOUT_PAYMENT);
        }

        $this->cc_card_type = $cc_validation->cc_type;
        $this->cc_card_number = $cc_validation->cc_number;
        $this->cc_expiry_month = $cc_validation->cc_expiry_month;
        $this->cc_expiry_year = $cc_validation->cc_expiry_year;
        $this->cc_checkcode = $HTTP_POST_VARS['paypalwpp_cc_checkcode'];
    }

    function confirmation() {
      global $HTTP_POST_VARS, $paypal_ec_token, $paypal_ec_payer_id, $paypal_ec_payer_info;

      if (tep_session_is_registered('paypal_ec_token') && tep_session_is_registered('paypal_ec_payer_id') && tep_session_is_registered('paypal_ec_payer_info')) {
        $confirmation = array('title' => MODULE_PAYMENT_PAYPAL_EC_TEXT_TITLE, 'fields' => array());
      } else {
        $confirmation = array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_TITLE,
                              'fields' => array(array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_FIRSTNAME,
                                                      'field' => $HTTP_POST_VARS['paypalwpp_cc_firstname']),
                                                array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_LASTNAME,
                                                      'field' => $HTTP_POST_VARS['paypalwpp_cc_lastname']),
                                                array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_TYPE,
                                                      'field' => $HTTP_POST_VARS['paypalwpp_cc_type']),
                                                array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_NUMBER,
                                                      'field' => substr($HTTP_POST_VARS['paypalwpp_cc_number'], 0, 4) . str_repeat('X', (strlen($HTTP_POST_VARS['paypalwpp_cc_number']) - 8)) . substr($HTTP_POST_VARS['paypalwpp_cc_number'], -4)),
                                                array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_EXPIRES,
                                                      'field' => strftime('%B, %Y', mktime(0,0,0,$HTTP_POST_VARS['paypalwpp_cc_expires_month'], 1, '20' . $HTTP_POST_VARS['paypalwpp_cc_expires_year'])))));

        if (tep_not_null($HTTP_POST_VARS['paypalwpp_cc_checkcode'])) {
          $confirmation['fields'][] = array('title' => MODULE_PAYMENT_PAYPAL_DP_TEXT_CREDIT_CARD_CHECKNUMBER,
                                            'field' => $HTTP_POST_VARS['paypalwpp_cc_checkcode']);
        }
      }
      return $confirmation;
    }

    function setShippingMethod() {
        // set the shipping method if one is not already set
        // make sure to default to the cheapest shipping method
        if (!tep_session_is_registered('shipping')) {
            require_once(DIR_WS_CLASSES . 'shipping.php');
            $shipping_Obj = new shipping;

            // gen the quotes
            $shipping_Obj->quote();

            // set the cheapest one
            tep_session_register('shipping');
            $_SESSION['shipping'] = $shipping_Obj->cheapest();
        }
    }

    function getLanguageCode() {
        // Find out the user's language so that if PayPal supports it, it'll
        // be the language used on PayPal's site.
        $lang_query = tep_db_query("SELECT CODE FROM " .
                                     TABLE_LANGUAGES . " WHERE languages_id = '" .
                                     $languages_id . "' LIMIT 1");

        // see if we got a lang back from the Lang query
        if (tep_db_num_rows($lang_query)) {
            $lang_id = tep_db_fetch_array($lang_query);
            // Only these 5 country codes are valid, so default to US for others.
            switch ($lang_id['code']) {
            case 'de':
                $lang_code = 'DE';
                break;
            case 'fr':
                $lang_code = 'FR';
                break;
            case 'it':
                $lang_code = 'IT';
                break;
            case 'ja':
                $lang_code = 'JP';
                break;
            default:
                $lang_code = 'US';
                break;
            }
        } else {
            // nothing found so assume US.
            $lang_code = 'US';
        }

        return $lang_code;
    }

    /**
     */
    function getOverrideAddress()
    {
        global $customer_id, $sendto;

        if (!empty($_GET['markflow']) && tep_session_is_registered('customer_id')) {
            // From now on for this user we will edit addresses on the
            // osc install, not by going to PayPal.
            tep_session_register('paypal_ec_markflow');
            $_SESSION['paypal_ec_markflow'] = 1;

            // find the users default address id
            if (!empty($sendto)) {
                $address_id = $sendto;
            } else {
                $default_address_id_query = tep_db_query('SELECT customers_default_address_id
                    FROM ' . TABLE_CUSTOMERS . '
                    WHERE customers_id = \'' . $customer_id . '\'');
                if (tep_db_num_rows($default_address_id_query) > 0) {
                    // grab the data
                    $default_address_id_arr = tep_db_fetch_array($default_address_id_query);
                    $address_id = $default_address_id_arr['customers_default_address_id'];
                } else {
                    // couldn't find an address.
                    return false;
                }
            }

            // now grab the address from the database and set it
            $address_query = tep_db_query('SELECT entry_firstname, entry_lastname,
                entry_street_address, entry_suburb, entry_city, entry_postcode,
                entry_country_id, entry_zone_id
                FROM ' . TABLE_ADDRESS_BOOK . '
                WHERE address_book_id = \'' . $address_id . '\' AND
                customers_id = \'' . $customer_id . '\'
                LIMIT 1');

            // see if we found a record, if not well we have nothing to override with
            if (tep_db_num_rows($address_query) > 0) {
                // grab the data
                $address_arr = tep_db_fetch_array($address_query);

                // get the state/prov code
                $state_query = tep_db_query('SELECT zone_code
                    FROM ' . TABLE_ZONES . '
                    WHERE zone_id = \'' . $address_arr['entry_zone_id'] . '\'');
                if (tep_db_num_rows($state_query) > 0) {
                    $state_code_arr = tep_db_fetch_array($state_query);
                } else {
                    $state_code_arr['zone_code'] = '';
                }
                $address_arr['zone_code'] = $state_code_arr['zone_code'];

                // get the country code
                // ISO 3166 standard country code
                $country_query = tep_db_query('SELECT countries_iso_code_2
                    FROM ' . TABLE_COUNTRIES . '
                    WHERE countries_id = \'' . $address_arr['entry_country_id'] . '\'');
                if (tep_db_num_rows($country_query) > 0) {
                    $country_code_arr = tep_db_fetch_array($country_query);
                } else {
                    // default to go old US
                    $country_code_arr['countries_iso_code_2'] = 'US';
                }
                $address_arr['countries_iso_code_2'] = $country_code_arr['countries_iso_code_2'];

                // return address data.
                return $address_arr;
            }
        }

        return false;
    }

    /**
     * This method attempts to match items in an address book, to avoid
     * duplicate entries to the addres book.  On a successfull match it
     * returns the address_book_id(int) on failure it returns false.
     *
     * @param int $customer_id
     * @param array $address_question_arr
     * @return int|boolean
     */
    function findMatchingAddressBookEntry($customer_id, $address_question_arr) {
        // first get the zone id's from the 2 digit iso codes
        // country first
        $country_query = tep_db_query('SELECT countries_id, address_format_id
            FROM ' . TABLE_COUNTRIES . '
            /*WHERE countries_iso_code_2 = \'' . $address_question_arr['country'] . '\' */
            WHERE countries_name = \'' . $address_question_arr['country'] . '\'
            LIMIT 1');

        // see if we found a record, if not default to American format
        if (tep_db_num_rows($country_query) > 0) {
            $country = tep_db_fetch_array($country_query);
            // grab the country id and address format
            $country_id = $country['countries_id'];
            $address_format_id = $country['address_format_id'];
        } else {
            // default
            $country_id = '223';
            $address_format_id = '2'; //2 is the American format
        }

        // see if the country code has a state
        $country_zone_check_query = tep_db_query('SELECT zone_country_id
            FROM ' . TABLE_ZONES . '
            WHERE zone_country_id = \'' . $country_id . '\'
            LIMIT 1');
        if (tep_db_num_rows($country_zone_check_query) > 0) {
            $check_zone = true;
        } else {
            $check_zone = false;
        }

        // now try and find the zone_id (state/province code)
        // use the country id above
        if ($check_zone) {
            $zone_query = tep_db_query('SELECT zone_id
                FROM ' . TABLE_ZONES . '
                WHERE zone_country_id = \'' . $country_id . '\' AND
                zone_code = \'' . $address_question_arr['state'] . '\'
                LIMIT 1');
            if (tep_db_num_rows($zone_query) > 0) {
                // grab the id
                $zone = tep_db_fetch_array($zone_query);
                $zone_id = $zone['zone_id'];
            } else {
                $check_zone = false;
            }
        }

        // so how to match, hmmm, lets do a match on address subrb
        if ($check_zone) {
            $question_query = tep_db_query('SELECT address_book_id, entry_street_address, entry_suburb
                FROM ' . TABLE_ADDRESS_BOOK . '
                WHERE customers_id = \'' . $customer_id . '\' AND
                entry_country_id = \'' . $country_id . '\' AND
                entry_zone_id = \'' . $zone_id .'\'');
        } else {
            $question_query = tep_db_query('SELECT address_book_id, entry_street_address, entry_suburb
                FROM ' . TABLE_ADDRESS_BOOK . '
                WHERE customers_id = \'' . $customer_id . '\' AND
                entry_country_id = \'' . $country_id . '\'');
        }
        $num = tep_db_num_rows($question_query);
        if ($num > 0) {
            // the match
            $matchQuestion = str_replace("\n", '', $address_question_arr['street_address']);
            $matchQuestion = trim($matchQuestion);
            $matchQuestion = $matchQuestion . str_replace("\n", '', $address_question_arr['suburb']);
            $matchQuestion = str_replace("\t", '', $matchQuestion);
            $matchQuestion = trim($matchQuestion);
            $matchQuestion = strtolower($matchQuestion);
            $matchQuestion = str_replace(' ', '', $matchQuestion);

            // go through the data
            for ($i = 0; $i < $num; $i++) {
                $answers_arr = tep_db_fetch_array($question_query);
                // now the matching logic

                // first from the db
                $fromDb = '';
                $fromDb = str_replace("\n", '', $answers_arr['entry_street_address']);
                $fromDb = trim($fromDb);
                $fromDb = $fromDb . str_replace("\n", '', $answers_arr['entry_suburb']);
                $fromDb = str_replace("\t", '', $fromDb);
                $fromDb = trim($fromDb);
                $fromDb = strtolower($fromDb);
                $fromDb = str_replace(' ', '', $fromDb);

                // check the strings
                if (strlen($fromDb) == strlen($matchQuestion)) {
                    if ($fromDb == $matchQuestion) {
                        // exact match return the id
                        return $answers_arr['address_book_id'];
                    }
                } elseif (strlen($fromDb) > strlen($matchQuestion)) {
                    $fromDb = substr($fromDb, 0, strlen($matchQuestion));
                    if ($fromDb == $matchQuestion) {
                        // we have a match return it
                        return $answers_arr['address_book_id'];
                    }
                } else {
                    $matchQuestion = substr($matchQuestion, 0, strlen($fromDb));
                    if ($fromDb == $matchQuestion) {
                        // we have a match return it
                        return $answers_arr['address_book_id'];
                    }
                }
            }
        }

        // no matches found
        return false;
    }

    /**
     * This method adds an adress book entry to the database, this allows us to add addresses
     * to the system that we get back from paypal that are not in the system
     *
     * @param int $customer_id
     * @param array $address_question_arr
     * @return int
     */
    function addAddressBookEntry($customer_id, $address_question_arr, $make_default = false) {
        // first get the zone id's from the 2 digit iso codes
        // country first
        $country_query = tep_db_query('SELECT countries_id, address_format_id
            FROM ' . TABLE_COUNTRIES . '
            WHERE countries_iso_code_2 = \'' . $address_question_arr['country'] . '\'
            LIMIT 1');

        // see if we found a record, if not default to American format
        if (tep_db_num_rows($country_query) > 0) {
            $country = tep_db_fetch_array($country_query);
            // grab the country id and address format
            $country_id = $country['countries_id'];
            $address_format_id = $country['address_format_id'];
        } else {
            // default
            $country_id = '223';
            $address_format_id = '2'; //2 is the American format
        }

        // see if the country code has a state
        $country_zone_check_query = tep_db_query('SELECT zone_country_id
            FROM ' . TABLE_ZONES . '
            WHERE zone_country_id = \'' . $country_id . '\'
            LIMIT 1');
        if (tep_db_num_rows($country_zone_check_query) > 0) {
            $check_zone = true;
        } else {
            $check_zone = false;
        }

        // now try and find the zone_id (state/province code)
        // use the country id above
        if ($check_zone) {
            $zone_query = tep_db_query('SELECT zone_id
                FROM ' . TABLE_ZONES . '
                WHERE zone_country_id = \'' . $country_id . '\' AND
                zone_code = \'' . $address_question_arr['state'] . '\'
                LIMIT 1');
            if (tep_db_num_rows($zone_query) > 0) {
                // grab the id
                $zone = tep_db_fetch_array($zone_query);
                $zone_id = $zone['zone_id'];
            } else {
                $check_zone = false;
            }
        }

        // now run the insert
        // this isnt the best way but it will get the majority of cases
        list($fname, $lname) = explode(' ', $address_question_arr['name']);
        if ($check_zone) {
            tep_db_query('INSERT INTO ' . TABLE_ADDRESS_BOOK . '
                (address_book_id, customers_id, entry_gender, entry_firstname, entry_lastname,
                entry_street_address, entry_suburb, entry_postcode, entry_city, entry_country_id,
                entry_zone_id)
                VALUES
                (NULL, \'' . $customer_id . '\', \'\', \'' . $fname . '\', \'' . $lname . '\',
                \'' . $address_question_arr['street_address'] . '\', \'' . $address_question_arr['suburb'] . '\',
                \'' . $address_question_arr['postcode'] . '\', \'' . $address_question_arr['city'] . '\',
                \'' . $country_id . '\', \'' . $zone_id . '\')');
        } else {
            tep_db_query('INSERT INTO ' . TABLE_ADDRESS_BOOK . '
                (address_book_id, customers_id, entry_gender, entry_firstname, entry_lastname,
                entry_street_address, entry_suburb, entry_postcode, entry_city, entry_country_id)
                VALUES
                (NULL, \'' . $customer_id . '\', \'\', \'' . $fname . '\', \'' . $lname . '\',
                \'' . $address_question_arr['street_address'] . '\', \'' . $address_question_arr['suburb'] . '\',
                \'' . $address_question_arr['postcode'] . '\', \'' . $address_question_arr['city'] . '\',
                \'' . $country_id . '\')');
        }
        $address_book_id = tep_db_insert_id();

        // make default if set, update
        if ($make_default) {
            tep_db_query('UPDATE '. TABLE_CUSTOMERS . '
                SET customers_default_address_id = \'' . $address_book_id . '\'
                WHERE customers_id = \'' . $customer_id . '\'');
            $_SESSION['customer_default_address_id'] = $address_book_id;
        }

        // set the sendto
        $_SESSION['sendto'] = $address_book_id;

        // return the address_id
        return $address_book_id;
    }

    function ec_step2_finish($paypal_ec_payer_info, $new_acct_notify) {
        // set globals
        global $customer_id, $customer_default_address_id, $sendto, $order, $language;

        // register the payer_info in the session
        tep_session_register('paypal_ec_payer_info');
        $_SESSION['paypal_ec_payer_info'] = $paypal_ec_payer_info;

        // Get the customer's country ID.
        $country_query = tep_db_query("SELECT countries_id, address_format_id
            FROM " . TABLE_COUNTRIES . "
            WHERE countries_name = '".$paypal_ec_payer_info['ship_country_name']."'
            LIMIT 1");

        // see if we found a record, if not default to American format
        if (tep_db_num_rows($country_query) > 0) {
            $country = tep_db_fetch_array($country_query);
            // grab the country id and address format
            $country_id = $country['countries_id'];
            $address_format_id = $country['address_format_id'];
        } else {
            // default
            $country_id = '223';
            $address_format_id = '2'; // 2 is the American format
        }

        // grab the state zone id
        $states_query = tep_db_query("SELECT zone_id FROM ".TABLE_ZONES." WHERE zone_code = '".$paypal_ec_payer_info['ship_state']."' AND zone_country_id = '".$country_id."' LIMIT 1");

        // see if we found a record
        if (tep_db_num_rows($states_query) > 0) {
            $states = tep_db_fetch_array($states_query);
            // grab the state zone_id
            $state_id = $states['zone_id'];
        } else {
            // default
            $state_id = 0;
        }

        // set the user info from the response back from paypal

        // customer
        $order->customer['name']            = $paypal_ec_payer_info['payer_firstname'] . ' ' . $paypal_ec_payer_info['payer_lastname'];
        $order->customer['company']         = $paypal_ec_payer_info['payer_business'];
        $order->customer['street_address']  = $paypal_ec_payer_info['ship_street_1'];
        $order->customer['suburb']          = $paypal_ec_payer_info['ship_street_2'];
        $order->customer['city']            = $paypal_ec_payer_info['ship_city'];
        $order->customer['postcode']        = $paypal_ec_payer_info['ship_postal_code'];
        $order->customer['state']           = $paypal_ec_payer_info['ship_state'];
        $order->customer['country']         = $paypal_ec_payer_info['ship_country_name'];
        $order->customer['format_id']       = $address_format_id;
        $order->customer['email_address']   = $paypal_ec_payer_info['payer_email'];
        $order->customer['telephone']       = $paypal_ec_payer_info['ship_phone'];

        // billing
        $order->billing['name']             = $paypal_ec_payer_info['payer_firstname'] . ' ' . $paypal_ec_payer_info['payer_lastname'];
        $order->billing['company']          = $paypal_ec_payer_info['payer_business'];
        $order->billing['street_address']   = $paypal_ec_payer_info['ship_street_1'];
        $order->billing['suburb']           = $paypal_ec_payer_info['ship_street_2'];
        $order->billing['city']             = $paypal_ec_payer_info['ship_city'];
        $order->billing['postcode']         = $paypal_ec_payer_info['ship_postal_code'];
        $order->billing['state']            = $paypal_ec_payer_info['ship_state'];
        $order->billing['country']          = $paypal_ec_payer_info['ship_country_name'];
        $order->billing['format_id']        = $address_format_id;

        // delivery
        $order->delivery['name']            = $paypal_ec_payer_info['payer_firstname'] . ' ' . $paypal_ec_payer_info['payer_lastname'];
        $order->delivery['company']         = $paypal_ec_payer_info['payer_business'];
        $order->delivery['street_address']  = $paypal_ec_payer_info['ship_street_1'];
        $order->delivery['suburb']          = $paypal_ec_payer_info['ship_street_2'];
        $order->delivery['city']            = $paypal_ec_payer_info['ship_city'];
        $order->delivery['postcode']        = $paypal_ec_payer_info['ship_postal_code'];
        $order->delivery['state']           = $paypal_ec_payer_info['ship_state'];
        $order->delivery['country']         = $paypal_ec_payer_info['ship_country_name'];
        $order->delivery['format_id']       = $address_format_id;

        // register the express check out temp
        if (!tep_session_is_registered('paypal_ec_temp')) tep_session_register('paypal_ec_temp');

        // see if the user is logged in
        if (tep_session_is_registered('customer_first_name') && tep_session_is_registered('customer_id')) {
            // They're logged in, so forward them straight to checkout_shipping.php
            // set the order customer_id
            $order->customer['id'] = $customer_id;

            // register sendto
            if (!tep_session_is_registered('sendto')) tep_session_register('sendto');

            // set the session info for the sendto
            $_SESSION['sendto'] = $customer_default_address_id;

            // set the session value for express checkout temp
            $_SESSION['paypal_ec_temp'] = false;

            // This is the address matching section
            // try to match it first
            // note: this is by no means 100%
            $address_book_id = $this->findMatchingAddressBookEntry($customer_id, $order->delivery);

            // no match add the record
            if (!$address_book_id) {
                $address_book_id = $this->addAddressBookEntry($customer_id, $order->delivery, false);
            }

            // set the address for use
            $_SESSION['sendto'] = $address_book_id;

            // set the users billto information (default address)
            if (!isset($_SESSION['billto'])) {
                $_SESSION['billto'] = $_SESSION['customer_default_address_id'];
            }

            // send the user on
            $this->away_with_you('', false, 'checkout_confirmation.php');
        } else {
            // They're not logged in.  Create an account if necessary, and then
            // log them in.
            // First, see if they're an existing customer
            // If Paypal didn't send an email address, something went wrong
            if (trim($paypal_ec_payer_info['payer_email']) == '') $this->away_with_you(MODULE_PAYMENT_PAYPAL_DP_INVALID_RESPONSE, true);

            // query to try and grab the user information using the payer_email from the
            // paypal information from the response
            $check_customer_query = tep_db_query("SELECT customers_id,
                customers_firstname, customers_lastname, customers_paypal_payerid,
                customers_paypal_ec
                FROM " . TABLE_CUSTOMERS . "
                WHERE customers_email_address = '" . tep_db_input($paypal_ec_payer_info['payer_email']) . "'");
            $check_customer = tep_db_fetch_array($check_customer_query);

            // see if we found an account that matches the email address given
            // back from paypal
            $acct_exists = false;
            if (tep_db_num_rows($check_customer_query) > 0) {
                $check_customer = tep_db_fetch_array($check_customer_query);
                $acct_exists = true;

                // see if this was only a temp account if so remove it
                if ($check_customer['customers_paypal_ec'] == '1') {
                    // Delete the existing temporary account
                    $this->ec_delete_user($check_customer['customers_id']);
                    $acct_exists = false;
                }
            }

            // Create an account, if the account does not exist
            if (!$acct_exists) {
                // Generate a random 8-char password
                $salt = '46z3haZzegmn676PA3rUw2vrkhcLEn2p1c6gf7vp2ny4u3qqfqBh5j6kDhuLmyv9xf';
                srand((double)microtime() * 1000000);
                $password = '';
                for ($x = 0; $x < 7; $x++) {
                    $num = rand() % 33;
                    $tmp = substr($salt, $num, 1);
                    $password = $password . $tmp;
                }

                // set the customer information in the array for the table insertion
                $sql_data_array = array('customers_firstname'       => $paypal_ec_payer_info['payer_firstname'],
                                        'customers_lastname'            => $paypal_ec_payer_info['payer_lastname'],
                                        'customers_email_address'       => $paypal_ec_payer_info['payer_email'],
                                        'customers_telephone'           => $paypal_ec_payer_info['ship_phone'],
                                        'customers_fax'                 => '',
                                        'customers_gender'              => '',
                                        'customers_newsletter'          => '0',
                                        'customers_password'            => tep_encrypt_password($password),
                                        'customers_paypal_payerid'      => $paypal_ec_payer_id);

                // insert the data
                $result = tep_db_perform(TABLE_CUSTOMERS, $sql_data_array);

                // grab the customer_id (last insert id)
                $customer_id = tep_db_insert_id();

                // set the customer address information in the array for the table insertion
                $sql_data_array = array('customers_id'              => $customer_id,
                                        'entry_gender'              => '',
                                        'entry_firstname'           => $paypal_ec_payer_info['payer_firstname'],
                                        'entry_lastname'            => $paypal_ec_payer_info['payer_lastname'],
                                        'entry_street_address'      => $paypal_ec_payer_info['ship_street_1'],
                                        'entry_suburb'              => $paypal_ec_payer_info['ship_street_2'],
                                        'entry_city'                => $paypal_ec_payer_info['ship_city'],
                                        'entry_zone_id'             => $state_id,
                                        'entry_postcode'            => $paypal_ec_payer_info['ship_postal_code'],
                                        'entry_country_id'          => $country_id);

                // insert the data
                tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);

                // grab the address_id (last insert id)
                $address_id = tep_db_insert_id();

                // set the address id lookup for the customer
                tep_db_query("update " . TABLE_CUSTOMERS . " set customers_default_address_id = '" . (int)$address_id . "' where customers_id = '" . (int)$customer_id . "'");

                // insert into the customers info table, the new customer_id
                tep_db_query("insert into " . TABLE_CUSTOMERS_INFO . " (customers_info_id, customers_info_number_of_logons, customers_info_date_account_created) values ('" . (int)$customer_id . "', '0', now())");

                if ($new_acct_notify == 'Yes') {
                    // require the language file
                    require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CREATE_ACCOUNT);

                    // set the mail text
                    $email_text = sprintf(EMAIL_GREET_NONE, $paypal_ec_payer_info['payer_firstname']) . EMAIL_WELCOME . EMAIL_TEXT;
                    $email_text .= EMAIL_EC_ACCOUNT_INFORMATION . "Username: " . $paypal_ec_payer_info['payer_email'] . "\nPassword: " . $password . "\n\n";
                    $email_text .= EMAIL_CONTACT;

                    // send the mail
                    tep_mail($paypal_ec_payer_info['payer_firstname'] . " " . $paypal_ec_payer_info['payer_lastname'], $paypal_ec_payer_info['payer_email'], EMAIL_SUBJECT, $email_text, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);

                    // set the express checkout temp
                    $_SESSION['paypal_ec_temp'] = false;
                } else {
                    // Make it a temporary account that'll be deleted once they've checked out
                    tep_db_query("UPDATE " . TABLE_CUSTOMERS . "
                        SET customers_paypal_ec = '1'
                        WHERE customers_id = '" . (int)$customer_id . "'");

                    // set the boolean ec temp value
                    $_SESSION['paypal_ec_temp'] = True;
                }
            } else {
                // set the boolean ec temp value for the account created
                $_SESSION['paypal_ec_temp'] = false;
            }

            // log the user in with the email sent back from paypal response
            $this->user_login($_SESSION['paypal_ec_payer_info']['payer_email'], false);

            // now do the shipping
            require_once(DIR_WS_CLASSES . 'shipping.php');
            $shipping_Obj = new shipping;

            // gen the quotes
            $shipping_Obj->quote();

            // set the cheapest one
            tep_session_register('shipping');
            $_SESSION['shipping'] = $shipping_Obj->cheapest();

            // This is the address matching section
            // try to match it first
            // note: this is by no means 100%
            $address_book_id = $this->findMatchingAddressBookEntry($customer_id, $order->delivery);

            // no match add the record
            if (!$address_book_id) {
                $address_book_id = $this->addAddressBookEntry($customer_id, $order->delivery, false);
            } else {
                $address_book_id = $_SESSION['customer_default_address_id'];
            }

            // set the sendto to the address
            $sendto = $address_book_id;

            // set sendto in the session
            tep_session_register('sendto');
            $_SESSION['sendto'] = $sendto;

            // set the bill to information
            $billto = $address_book_id;

            // set billto in the session
            tep_session_register('billto');
            $_SESSION['billto'] = $_SESSION['customer_default_address_id'];

            // send the user on
            $this->away_with_you('', false, 'checkout_confirmation.php');
        }
    }

    function user_login($email_address, $redirect = true) {
        global $order, $customer_id, $customer_default_address_id, $customer_first_name, $customer_country_id, $customer_zone_id;

        global $session_started, $language, $cart;
        if ($session_started == false) {
            tep_redirect(tep_href_link(FILENAME_COOKIE_USAGE));
        }

        require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_LOGIN);

        $check_customer_query = tep_db_query("select customers_id, customers_firstname, customers_password, customers_email_address, customers_default_address_id, customers_paypal_payerid from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($email_address) . "'");
        $check_customer = tep_db_fetch_array($check_customer_query);

        if (!tep_db_num_rows($check_customer_query)) {
            $this->away_with_you(MODULE_PAYMENT_PAYPAL_DP_TEXT_BAD_LOGIN, true);
        }

        if (SESSION_RECREATE == 'True') {
            tep_session_recreate();
        }

        $check_country_query = tep_db_query("select entry_country_id, entry_zone_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$check_customer['customers_id'] . "' and address_book_id = '" . (int)$check_customer['customers_default_address_id'] . "'");
        $check_country = tep_db_fetch_array($check_country_query);

        $customer_id = $check_customer['customers_id'];
        $customer_default_address_id = $check_customer['customers_default_address_id'];
        $customer_first_name = $check_customer['customers_firstname'];
        $customer_country_id = $check_country['entry_country_id'];
        $customer_zone_id = $check_country['entry_zone_id'];
        tep_session_register('customer_id');
        tep_session_register('customer_default_address_id');
        tep_session_register('customer_first_name');
        tep_session_register('customer_country_id');
        tep_session_register('customer_zone_id');

        $order->customer['id'] = $customer_id;

        tep_db_query("update " . TABLE_CUSTOMERS_INFO . " set customers_info_date_of_last_logon = now(), customers_info_number_of_logons = customers_info_number_of_logons+1 where customers_info_id = '" . (int)$customer_id . "'");

        $cart->restore_contents();
        if ($redirect) {
            $this->away_with_you();
        }

        return true;
    }

    function ec_delete_user($cid) {
      global $customer_id, $customers_default_address_id, $customer_first_name, $customer_country_id, $customer_zone_id, $comments;
      tep_session_unregister('customer_id');
      tep_session_unregister('customer_default_address_id');
      tep_session_unregister('customer_first_name');
      tep_session_unregister('customer_country_id');
      tep_session_unregister('customer_zone_id');
      tep_session_unregister('comments');

      tep_db_query("delete from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$cid . "'");
      tep_db_query("delete from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$cid . "'");
      tep_db_query("delete from " . TABLE_CUSTOMERS_INFO . " where customers_info_id = '" . (int)$cid . "'");
      tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . (int)$cid . "'");
      tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET_ATTRIBUTES . " where customers_id = '" . (int)$cid . "'");
      tep_db_query("delete from " . TABLE_WHOS_ONLINE . " where customer_id = '" . (int)$cid . "'");
    }

    function setStateAndCountry($info) {
        // Thanks goes to SteveDallas for improved international support
        // Set the state field depending on what PayPal wants to see for that country
        switch ($info['country']['iso_code_2']) {
        case 'US':
        case 'CA':
            // Paypal only accepts two character state/province codes for some countries
            if (strlen($info['state']) > 2) {
                $state_query = tep_db_query("SELECT zone_code FROM " . TABLE_ZONES . " WHERE zone_name = '".$info['state']."'");
                if (tep_db_num_rows($state_query) > 0) {
                    $state = tep_db_fetch_array($state_query);
                    $info['state'] = $state['zone_code'];
                } else {
                    $this->away_with_you(MODULE_PAYMENT_PAYPAL_DP_TEXT_STATE_ERROR);
                }
            }
            if (strlen($order->delivery['state']) > 2) {
                $state_query = tep_db_query("SELECT zone_code FROM " . TABLE_ZONES . " WHERE zone_name = '".$order->delivery['state']."'");
                if (tep_db_num_rows($state_query) > 0) {
                    $state = tep_db_fetch_array($state_query);
                    $order->delivery['state'] = $state['zone_code'];
                } else {
                    $this->away_with_you(MODULE_PAYMENT_PAYPAL_DP_TEXT_STATE_ERROR);
                }
            }
            break;

        case 'AT':
        case 'BE':
        case 'FR':
        case 'DE':
        case 'CH':
            $info['state'] = '';
            break;
        }
    }

    function after_process() {
        global $insert_id;

        tep_db_query("update ".TABLE_ORDERS_STATUS_HISTORY. " set comments = concat(if (trim(comments) != '', concat(trim(comments), '\n'), ''), 'Transaction ID: ".$this->trans_id."\nPayment Type: ".$this->payment_type."\nPayment Status: ".$this->payment_status.($this->avs != 'N/A' ? "\nAVS Code: ".$this->avs."\nCVV2 Code: ".$this->cvv2 : '')."') where orders_id = ".$insert_id);
    }

    function get_error() {
        global $HTTP_GET_VARS, $language;
        require(DIR_WS_LANGUAGES . $language . '/modules/payment/' . FILENAME_PAYPAL_WPP);

        $error = array('title' => MODULE_PAYMENT_PAYPAL_DP_ERROR_HEADING,
                       'error' => ((isset($HTTP_GET_VARS['error'])) ? stripslashes(urldecode($HTTP_GET_VARS['error'])) : MODULE_PAYMENT_PAYPAL_DP_TEXT_CARD_ERROR));

        return $error;
    }

    function remove() {
        tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

}
