<?php
/*
  $Id: $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2002 osCommerce

  Released under the GNU General Public License
  
  Modified by Frank de Badts (frank@debadts.com) for new osCommerce checkout (>Nov 2002) procedure.
  Tested with Ogone eCommerce version Jan 2003 and later. For more
  infomation about OGONE: http://www.ogone.be or http://www.ogone.nl
  To see this payment module in action see http://www.knuffelpost.nl (Dutch)
*/

  class ogone {
    var $code, $title, $description, $enabled;

// class constructor
    function ogone() {
      $this->code = 'ogone';
      $this->title = MODULE_PAYMENT_OGONE_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_OGONE_TEXT_DESCRIPTION;
      $this->enabled = MODULE_PAYMENT_OGONE_STATUS;
	  $this->form_action_url = 'https://secure.ogone.com/ncol/' . MODULE_PAYMENT_OGONE_MODE . '/orderstandard.asp';
    }

// class methods
    function javascript_validation() {
      return true;
    }

    function selection() {
    return array('id' => $this->code,'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return false;
    }
    /* For a detailled spec on these fields for ogone see https://secure.ogone.com/ncol/test/admin_ogone.asp */
    function process_button() {
      global $HTTP_POST_VARS, $customer_id, $order, $currencies;

      $ogone_orderID = $customer_id . date('YmdHis');
      $ogone_amount = number_format($order->info['total'] * 100 * $order->info['currency_value'], 0, '', '');

      $process_button_string = tep_draw_hidden_field('orderID', $ogone_orderID) .
                               tep_draw_hidden_field('pspid', MODULE_PAYMENT_OGONE_PSPID) .
                               tep_draw_hidden_field('RL', 'ncol-2.0') .
                               tep_draw_hidden_field('currency', $order->info['currency']) .
                               tep_draw_hidden_field('language', $language_&$language) .
                               tep_draw_hidden_field('amount', $ogone_amount) .
  				            /* tep_draw_hidden_field('TP','http://your_template.htm') . Note: Use only for Ogone checkout static template */
							   tep_draw_hidden_field('TITLE',MODULE_PAYMENT_OGONE_TITLE_OGONE) .
							   tep_draw_hidden_field('BGCOLOR','white') .
							   tep_draw_hidden_field('TXTCOLOR','black') .
							   tep_draw_hidden_field('TBLBGCOLOR','white') .
 							   tep_draw_hidden_field('TBLTXTCOLOR','black') .
 							   tep_draw_hidden_field('BUTTONBGCOLOR','white') .
							   tep_draw_hidden_field('"BUTTONTXTCOLOR','#FFFFFF') .
                            /* tep_draw_hidden_field('"LOGO','Mylogo.jpg') . Note: Only use if you have a logo on the Ogone checkout page*/
        			           tep_draw_hidden_field('"FONTTYPE','Verdana') .
						       tep_draw_hidden_field('accepturl', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')) .
                               tep_draw_hidden_field('declineurl', tep_href_link(FILENAME_SHOPPING_CART)) .
                               tep_draw_hidden_field('exceptionurl', tep_href_link(FILENAME_SHOPPING_CART)) .
                               tep_draw_hidden_field('cancelurl', tep_href_link(FILENAME_SHOPPING_CART)) .
                               tep_draw_hidden_field('CN', $order->customer['firstname'] . ' ' . $order->customer['lastname']) .
                               tep_draw_hidden_field('catalogurl', tep_href_link(FILENAME_DEFAULT)) .
      	                       tep_draw_hidden_field('owneraddress', $order->delivery['street_address']) .
 				               tep_draw_hidden_field('ownerZIP', $order->delivery['postcode']) .
						   /*  tep_draw_hidden_field('PM','CreditCard') . */
						   /*  tep_draw_hidden_field('BRAND','VISA') .    Note: Optional Payment Method details :If PM/BRAND fields are filled, the buyer is directed immediately to the relevant payment method page */
  			               /*  tep_draw_hidden_field('UsedID', '12345') . Note: UserID optional, only for merchants using the Ogone User Manager */
						       tep_draw_hidden_field('COM', MODULE_PAYMENT_OGONE_COM_DESCRIPTION . $customer_id) .
tep_draw_hidden_field('PARAMPLUS', tep_session_name().'='.tep_session_id()) .
  							   tep_draw_hidden_field('email', $order->customer['email_address']);

      include(DIR_WS_CLASSES . 'sha.php');
      $sha = new SHA;
      $hasharray = $sha->hash_string($ogone_orderID . $ogone_amount . $order->info['currency'] . MODULE_PAYMENT_OGONE_PSPID . MODULE_PAYMENT_OGONE_SHA_STRING);
      $process_button_string .= tep_draw_hidden_field('SHASign', $sha->hash_to_string($hasharray));

      return $process_button_string;
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function output_error() {
      return false;
    }


    function check() {
      if (!isset($this->check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_OGONE_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }
      return $this->check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Allow OGONE Payments', 'MODULE_PAYMENT_OGONE_STATUS', '1', 'Do you want to accept OGONE payments?', '6', '20', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('OGONE Status Mode', 'MODULE_PAYMENT_OGONE_MODE', 'test', 'Status mode for OGONE payments? (test or prod)', '6', '21', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('OGONE Merchant ID', 'MODULE_PAYMENT_OGONE_PSPID', 'TESTSTD', 'Merchant NCOL ID', '6', '22', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('OGONE Client Language', 'MODULE_PAYMENT_OGONE_LANGUAGE', 'en_US', 'Client language', '6', '23', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('OGONE SHA String', 'MODULE_PAYMENT_OGONE_SHA_STRING', '', 'SHA string used for the signature (set at the merchant administration page)', '6', '24', now())");
    }

    function remove() {
      $keys = '';
      $keys_array = $this->keys();
      for ($i=0; $i<sizeof($keys_array); $i++) {
        $keys .= "'" . $keys_array[$i] . "',";
      }
      $keys = substr($keys, 0, -1);

      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
    }

    function keys() {
      return array('MODULE_PAYMENT_OGONE_STATUS', 'MODULE_PAYMENT_OGONE_MODE', 'MODULE_PAYMENT_OGONE_PSPID', 'language', 'MODULE_PAYMENT_OGONE_SHA_STRING');
    }
  }
?>
