<?php
/*
 * $Id: invoice.php,v 1.1 2007/09/23 20:04:34 jm Exp $
 * 
 * Created on 13 mars 07 by AEL Sarl for
 * 
 * osCommerce, Open Source E-Commerce Solutions
 * http://www.oscommerce.com
 *
 * Copyright (c) 2003 osCommerce
 *
 * Released under the GNU General Public License
 * 
 */
  
  require('export_invoices_counters.php');
  
  class placeholder {
  	/**
  	 * A generic placeholder formatter
  	 * 
  	 * @author AEL Sarl
  	 */
  	var $next_handler;
  	
  	function placeholder($next_handler = NULL) {
  		/**
  		 * placeholder constructor
  		 * @param next_handler the handler which will be requested if this one decline the request
  		 */
  		$this->next_handler = $next_handler;
  	}
  	
  	function add($handler) {
  		/**
  		 * add a handler to the list
  		 * @param handler the handler to add
  		 */
  		$current = $this;
  		while (!is_null($current->next_handler))
  			$current = $current->next_handler;
  		$current->next_handler = $handler;
  		return $this;
  	}
  	
  	function format($string, $value='') {
  		/**
  		 * format a string (does nothing)
  		 * @param string string to format
  		 * @param value  value used in the formatted string
  		 * @return the original string
  		 */
  		return $string;
  	}
  }
  
  class datetimePlaceholder extends placeholder {
  	/**
  	 * a placeholder formatter for a datetime format string
  	 * @author AEL Sarl
  	 */
  	
  	function datetimePlaceholder($next_handler = NULL) {
  		/**
  		 * datetimePlaceholder constructor
  		 * @param next_handler the handler which will be requested if this one decline the request
  		 */
  		parent::placeholder($next_handler);
  	}
  	
  	function format($string, $value='') {
  		/**
  		 * format a string with the strftime() function
  		 * @param string string to format
  		 * @param value  value used in the formatted string (useless)
  		 * @return the formatted string
  		 */
  		if ($string{0} == "%" && (strtolower($string{1})) == "y")
  			return strftime($string);
  		if (!is_null($this->next_handler))
  			return $this->next_handler->format($string, $value);
  		return $string;
  	}
  }
  
  class intPlaceholder extends placeholder {
  	/**
  	 * a placeholder formatter for a format string accepting int values
  	 * @author AEL Sarl
  	 */
  	function intPlaceholder($next_handler = NULL) {
  		/**
  		 * intPlaceholder constructor
  		 * @param next_handler the handler which will be requested if this one decline the request
  		 */
  		parent::placeholder($next_handler);
  	}
  	
  	function format($string, $value=1) {
  		/**
  		 * format a string with the printf() like function
  		 * @param string the string to format
  		 * @param value  the int value used in the formatted string
  		 * @return the formatted string
  		 */
  		if (ereg('^%0?[1-9]?d', $string))
  			return vsprintf($string, (int)$value);
  		if (!is_null($this->next_handler))
  			return $this->next_handler->format($string, $value);
  		return $string;
  	}
  }
  
  class director {
  	/**
  	 * A manager registering the placeholder instances and handling a request
  	 * @author AEL Sarl
  	 */
  	var $first_handler;
  	
  	function director($first_handler) {
  		/**
  		 * director constructor
  		 * @param first_handler the first handler of the handlers chain
  		 */
  		$this->first_handler = $first_handler;
  	}
  	
  	function handle($string, $value) {
  		/**
  		 * A handler
  		 * @param string the format string we want to process
  		 * @param value  the value associated with the format string
  		 * @return a formatted string processed by the registered placeholders instances
  		 */
  		$formatted = '';
  		$placeholders = array();
  		if (($pos = strpos($string, '%')) !== false) {
  			$tok = strtok($string, '%');
  			while ($tok !== false) {
  				array_push($placeholders, $tok);
  				$tok = strtok('%');
  			}
  			// do not format the first token
  			if ($pos > 0)
  				$formatted = array_shift($placeholders);
  			foreach ($placeholders as $key => $token)
  				$formatted .= $this->first_handler->format('%' . $token, $value);
  		}
  		return $formatted;
  	}
  }
  
  class invoice {
  	/**
  	 * An invoice
  	 * @author AEL Sarl
  	 */
  	var $format, $counter;
  	
  	function invoice($format) {
  		/**
  		 * invoice constructor
  		 * @param format the format string for the invoice number
  		 */
  		$this->format = $format;
  		$this->counter = new eiCounters('INVOICE_COUNTER');
  	}
  	
  	function compute_new_invoice_number($invoice_number) {
  		/**
  		 * Compute a new invoice number, according to the specified format attribute
  		 * @return the formatted string value of the invoice number
  		 */
  		$dr = new director(new datetimePlaceholder(new intPlaceholder()));
  		return $dr->handle($this->format, $invoice_number);
  	}
  	
  	function insert() {
  		/**
  		 * insert an invoice and update the counter
  		 * @return the new invoice identifier 
  		 */
  		 
  		 $new_counter_value = $this->counter->counters_value ? (int)$this->counter->counters_value + 1 : 1;
  		 $invoice_number = $this->compute_new_invoice_number($new_counter_value);
  		 $this->counter->insert($new_counter_value);
  		 tep_db_perform(TABLE_INVOICE, array('invoice_id' => null, 'invoice_number' => $invoice_number, 'invoice_date' => 'now()')); 
  		 return tep_db_insert_id();
	  }
  }

?>